/*
    Copyright (C) 2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "proxyinfo.h"
#include "settings_general.h"
#include <KUrl>
#include <QByteArray>

// defination of static member (in the class declaration in header file, it is
//                              only declared, not defined)
proxyinfo proxyinfo::internal_instance;

proxyinfo::proxyinfo()
{
#ifdef LIBPROXY_FOUND
  libproxy_factory = px_proxy_factory_new();
#endif
}

proxyinfo::~proxyinfo()
{
#ifdef LIBPROXY_FOUND
  px_proxy_factory_free(libproxy_factory);
#endif
}

QStringList proxyinfo::proxyserver(const QString & url)
{
  return proxyinfo::internal_instance.internal_proxyserver(url);
}

#ifdef LIBPROXY_FOUND
QStringList proxyinfo::internal_proxyserver(const QString & url) const
{
  if (settings_general::proxyConfiguration() ==
      settings_general::EnumProxyConfiguration::automatic) {
    QStringList returnValue;
    // C string of the encoded (domain in punycode, rest is percent-encoded) ASCII-only URL
    QByteArray c_encoded_url = KUrl(url).toEncoded();
    // get proxy list (A NULL-terminated array of strings) from libproxy
    char **proxies = px_proxy_factory_get_proxies(proxyinfo::libproxy_factory,
                                                  c_encoded_url.data());
    // construct the QStringList from this array
    for (int i=0; proxies[i]; ++i) {
      returnValue.append(proxies[i]);
    };
    if (returnValue.size() < 1) {
      // makes sure that there is at least 1 entry, without relaing on the external lib for this
      returnValue.append("direct://");
    };
    // free the array
    for (int i=0; proxies[i]; ++i) {
      free(proxies[i]);
    };
    free(proxies);
    return returnValue;
  } else {
    return manual_proxyserver();
  };
}
#else
QStringList proxyinfo::internal_proxyserver(const QString &) const
{
  return manual_proxyserver();
}
#endif

QStringList proxyinfo::manual_proxyserver() const
{
  QStringList returnValue;
  QString temp_server = settings_general::proxyServer();
  if (temp_server.isEmpty()) {
    returnValue.append("direct://");
  } else {
    returnValue.append(temp_server);
  };
  return returnValue;
}
