/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STREAMDIRECTORYMODEL_H
#define STREAMDIRECTORYMODEL_H

#include <QAbstractItemModel>
#include <KIcon>
#include "streamdirectoryentry_root.h"

/** \brief A model which provides a stream directory.
*
* This is an abstract base class for Qt tree models that provide stream directories.
*
* The internal data structure is based on the abstract class #streamDirectoryEntry and especially
* on its implementation #streamDirectoryEntry_root, which is used as root item for this model. */
class streamDirectoryModel : public QAbstractItemModel
{

  Q_OBJECT

  public:
    /** Constructor of the class.
    * @param parent Sets the parent widget of this object.
    * @param genreIconFileName See #genreIcon for details. */
    explicit streamDirectoryModel(QObject *parent, const QString & genreIconFileName = QString());
    /** The desctructor. */
    virtual ~streamDirectoryModel();
    /** Reimplemented from base class. */
    virtual int columnCount(const QModelIndex & parent = QModelIndex()) const;
    /** Reimplemented from base class.
    * \note For the role \e Qt::UserRole this function provides the same data as for
    * \e Qt::DisplayRole, but without being formated. This is useful for sorting. */
    virtual QVariant data(const QModelIndex & index, int role = Qt::DisplayRole) const;
    /** Reimplemented from base class. */
    virtual Qt::ItemFlags flags(const QModelIndex & index) const;
    /** Reimplemented from base class. */
    virtual bool hasChildren(const QModelIndex & parent = QModelIndex()) const;
    virtual QVariant headerData(int section,
                                Qt::Orientation orientation,
                                int role = Qt::DisplayRole) const;
    /** Reimplemented from base class. */
    virtual QModelIndex index (int row,
                               int column,
                               const QModelIndex & parent = QModelIndex()) const;
    /** Reimplemented from base class. */
    virtual QStringList mimeTypes() const;
    /** Reimplemented from base class. */
    virtual QMimeData *mimeData(const QModelIndexList & indexes) const;
    /** Reimplemented from base class. */
    virtual QModelIndex parent(const QModelIndex & index) const;
    /** Reimplemented from base class. */
    virtual int rowCount(const QModelIndex & parent = QModelIndex()) const;

  protected:
    /** A link to the root entry of the internal data structure. */
    streamDirectoryEntry_root *rootEntry;

  private:
    /** Holds the icon the is used for the genres. The file path is set in the constructor and
    * later can't be changed anymore. */
    KIcon genreIcon;
};

#endif
