/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef STREAMDIRECTORYENTRY_STREAM_H
#define STREAMDIRECTORYENTRY_STREAM_H

#include "streamdirectoryentry.h"

/** \brief Data type representing a stream.
*
* This is a data type representing a stream with some information about it - within a tree
* structure.
* \sa stationDirectoryTree */
class streamDirectoryEntry_stream : public streamDirectoryEntry
{
  public:
    /** The constructor. */
    streamDirectoryEntry_stream();

    /** The destructor. */
    virtual ~streamDirectoryEntry_stream();

    /** A data type for the type of stream.
    * - \e unknown Type of stream could not be determinated.
    * - \e mp3 Codec is mp3 (http://en.wikipedia.org/wiki/MP3)
    * - \e ogg Container format is OGG. (http://en.wikipedia.org/wiki/Ogg)
    * - \e nsv Container format is NSV (http://en.wikipedia.org/wiki/Nullsoft_Streaming_Video)
    * - \e aac Codec is aac (http://en.wikipedia.org/wiki/Advanced_Audio_Coding), mime type is
    *   audio/aac
    * - \e aac_plus Codec is aac (http://en.wikipedia.org/wiki/Advanced_Audio_Coding), mime type
    *   is audio/aacp
    */
    enum type_of_stream {
      unknown,
      mp3,
      ogg,
      nsv,
      aac,
      aac_plus
    };

    /** The bitrate of the stream. Set this to 0 if unknown!
    *
    * Default value: 0 */
    quint64 bitrate;

    /** Holds whether the stream provides useful meta-information about the
    * actually played song.
    *
    * Default value: false */
    bool currentlyPlaying;

    /** Returns the data of the stream.
    * @param column The column for which the data is reported. */
    virtual QVariant data(const int column) const;

    /** Returns a formated (human readable and localized) version of the stream type.
    * @param streamType The stream type that which you want to get the formated version. */
    static QString formatedStreamType(const type_of_stream streamType);

    /** \returns false (A stream should not have children.) */
    virtual bool hasChildren() const;

    /** Reimplemented from base class. */
    QVariant rawData(const int column) const;

    /** The type of the stream. Set to \e unknown if it can not
    *   be determinated.
    *
    * Default value: unknown */
    type_of_stream streamType;
};

#endif
