/***************************************************************************
                          category.cpp  -  description
                             -------------------
    begin                : Ter Dez 31 2002
    copyright            : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kicondialog.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <kapplication.h>
#include "category.h"

CategoryDialog::CategoryDialog(QWidget *parent, const char *name ) : Category_Dlg(parent,name) {
	KIconLoader kil;
	kplb = 0;
	pm_tab->setPixmap( kil . loadIcon( "tab_new_bg.png", KIcon::Toolbar ) );
	icon_selector->setIcon ( KGlobal::dirs()->findResource( "data", "kpreg/pen.png" ) );
	connect( pb_insert, SIGNAL( clicked() ), this, SLOT( slotChangeCategory() ) );
	connect( pb_insert, SIGNAL( clicked() ), this, SLOT( slotEmitCategory() ) );
	connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( slotHelp() ) );
}

CategoryDialog::~CategoryDialog(){
}

void CategoryDialog::slotHelp (){
	kapp->invokeHelp( "category-dialog" );
}

void CategoryDialog::slotChangeCategory ()
{
	if (kplb != 0) {
		kplb->setCategoryIcon(icon_selector->icon());
		kplb->setCategoryLabel(le_title->text());
		kplb->atualizeViewCategory();
		this->accept ();
	}
}

void CategoryDialog::slotEmitCategory ()
{
	QDomDocument kpregDoc ("kpreg");
	QDomElement category = kpregDoc.createElement("category");
	kpregDoc . appendChild (category);

	category . setAttribute ( "label", le_title->text() );
	category . setAttribute ( "icon", icon_selector->icon() );

	emit newCategory(kpregDoc);

	this->accept ();
}

void CategoryDialog::setCategory ( KpregListBox *_kplb ){
	kplb = _kplb;
	icon_selector->setIcon ( kplb->getCategoryIcon () );
	le_title->setText ( kplb->getCategoryLabel () );
}

