/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "ScriptEditorDialog.h"

ScriptEditorDialog::ScriptEditorDialog()
{
	index = 0;
	setWindowIcon(QIcon(":/icons/cmd2.png"));
	QLabel *label = new QLabel(tr("<strong>Add shell commands</strong> to the list below <strong>and execute</strong> them <strong>by insertion order</strong> :"), this);
	addButton = new QPushButton(tr("Add new command"), this);
	startButton = new QPushButton(QIcon(":/icons/gnome-terminal.png"), tr("Execute ordered by insertion"), this);
	clearButton = new QPushButton(tr("Clear commands list"), this);
	closeButton = new QPushButton(tr("Close"), this);
	deleteButton  = new QPushButton(tr("Delete selected command"), this);
	commandLine = new QLineEdit(this);
	commandList = new QListView();
        commandStringList = XmlDataStore::getCommandList();;
	QGridLayout *scriptLayout = new QGridLayout;
        scriptLayout->addWidget(label, 0, 0);
	scriptLayout->addWidget(addButton, 2, 0);
	scriptLayout->addWidget(deleteButton, 3, 0);
	scriptLayout->addWidget(commandLine, 1, 0);
	scriptLayout->addWidget(commandList, 4, 0);
	scriptLayout->addWidget(clearButton, 5, 0);
	scriptLayout->addWidget(startButton, 6, 0, 2, 1);
	scriptLayout->addWidget(closeButton, 8, 0);
	setWindowFlags(Qt::Dialog);
	setWindowTitle(tr("Script editor"));
	setLayout(scriptLayout);
        scriptEditorModel =  new QStringListModel(commandStringList);
        commandList->setModel(scriptEditorModel);

	connect(addButton, SIGNAL(clicked()), this, SLOT(addCommandToList()));
	connect(startButton, SIGNAL(clicked()), this, SLOT(startNextThread()));
	connect(clearButton, SIGNAL(clicked()), this, SLOT(clearCommandsList()));
	connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteCommand()));
	connect(closeButton, SIGNAL(clicked()), this, SLOT(reject()));
}

void ScriptEditorDialog::clearCommandsList()
{
	commandStringList.clear();
	scriptEditorModel =  new QStringListModel(commandStringList);
	commandList->setModel(scriptEditorModel);
}

void ScriptEditorDialog::startNextThread()
{
        if (!commandStringList.isEmpty() && this->isVisible()) {
                if (index <= (commandStringList.size() - 1))
                {
                        emit sendCommand(commandStringList.at(index));
                        index = index +1;
                } else if (index == (commandStringList.size())) {
                        index = 0;
                        QMessageBox::information(this, tr("Commands completed"), tr("Each command has been executed succesfully."));
                }
        }
}

void ScriptEditorDialog::deleteCommand()
{
    QItemSelectionModel *selection = commandList->selectionModel();
    if (selection != NULL)
    {
    	QModelIndex indexElementSelectionne = selection->currentIndex();
    	commandStringList.removeAt(indexElementSelectionne.row());
    	scriptEditorModel =  new QStringListModel(commandStringList);
    	commandList->setModel(scriptEditorModel);
    } else {
                QMessageBox::information(this, tr("Warning"), tr("No selected command to delete."));
	}
}

void ScriptEditorDialog::addCommandToList()
{
	if (commandLine->text() != "") 
	{
		commandStringList.append(commandLine->text());
		scriptEditorModel =  new QStringListModel(commandStringList);
		commandList->setModel(scriptEditorModel);
		commandLine->setText("");
                XmlDataStore::saveCommandList(commandStringList);
	} else {
                QMessageBox::information(this, tr("Warning"), tr("Input a command into the field above before to add."));
	}
}

void ScriptEditorDialog::setIndexToZero()
{
    index = 0;
}
