/***************************************************************************
 *   Copyright (C) 2007-2009 by Thomas Thelliez <admin.kontrol@gmail.com>  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as               *
 *   published by the Free Software Foundation; either version 2.0 of      *
 *   the License, or (at your option) any later version.                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public             *
 *   License along with this program; if not, write to                     *
 *   the Free Software Foundation, Inc.,                                   *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
 ***************************************************************************/

#include "IpBlackList.h"

IpBlackList::IpBlackList()
{
        index = 0;
        setWindowIcon(QIcon(":/icons/cmd2.png"));
        QLabel *label = new QLabel(tr("<strong>IPs filter: workstations black list. The server will reject <br/>remote workstations corresponding to filtered IPs."), this);
        addButton = new QPushButton(tr("Filter IP address"), this);
        clearButton = new QPushButton(tr("Clear IP addresses list"), this);
        closeButton = new QPushButton(tr("Close"), this);
        deleteButton  = new QPushButton(tr("Remove selected filtered IP"), this);
        commandLine = new QLineEdit(this);
        commandList = new QListView();
        ipStringList = XmlDataStore::getFilteredIpsData();
        QGridLayout *scriptLayout = new QGridLayout;
        scriptLayout->addWidget(label, 0, 0, 1, 2);
        scriptLayout->addWidget(addButton, 1, 1);
        scriptLayout->addWidget(deleteButton, 2, 1);
        scriptLayout->addWidget(commandLine, 1, 0, 1, 1);
        scriptLayout->addWidget(commandList, 4, 0, 1, 2);
        scriptLayout->addWidget(clearButton, 2, 0);
        scriptLayout->addWidget(closeButton, 5, 0, 1, 2);
        setWindowFlags(Qt::Dialog);
        setWindowTitle(tr("IPs Filter"));
        scriptEditorModel =  new QStringListModel(ipStringList);
        commandList->setModel(scriptEditorModel);
        setLayout(scriptLayout);
        connect(addButton, SIGNAL(clicked()), this, SLOT(addCommandToList()));
        connect(clearButton, SIGNAL(clicked()), this, SLOT(clearCommandsList()));
        connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteCommand()));
        connect(closeButton, SIGNAL(clicked()), this, SLOT(reject()));
}

void IpBlackList::clearCommandsList()
{
        ipStringList.clear();
        scriptEditorModel =  new QStringListModel(ipStringList);
        commandList->setModel(scriptEditorModel);
        XmlDataStore::saveFilteredIpsData(ipStringList);
}


void IpBlackList::deleteCommand()
{
    QItemSelectionModel *selection = commandList->selectionModel();
    if (selection != NULL)
    {
        QModelIndex indexElementSelectionne = selection->currentIndex();
        ipStringList.removeAt(indexElementSelectionne.row());
        scriptEditorModel =  new QStringListModel(ipStringList);
        commandList->setModel(scriptEditorModel);
        XmlDataStore::saveFilteredIpsData(ipStringList);
    } else {
                QMessageBox::information(this, tr("Warning"), tr("No selected IPs. Nothing to delete."));
        }
}

void IpBlackList::addCommandToList()
{
        if (commandLine->text() != "")
        {
                ipStringList.append(commandLine->text());
                scriptEditorModel =  new QStringListModel(ipStringList);
                commandList->setModel(scriptEditorModel);
                commandLine->setText("");
                XmlDataStore::saveFilteredIpsData(ipStringList);
                QMessageBox::information(this, tr("Warning"), tr("Restart KontrolPack to be sure that filters will be correctly applied."));
        } else {
                QMessageBox::information(this, tr("Warning"), tr("Input a command into the field above before to add."));
        }
}

void IpBlackList::closeEvent(QCloseEvent *event)
{
    QMessageBox::information(this, tr("Warning"), tr("Restart KontrolPack to be sure that filters will be correctly applied."));
}

void IpBlackList::setIndexToZero()
{
    index = 0;
}


