/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kconfig.h>
#include <kdialogbase.h>
#include <kpushbutton.h>
#include <ktextedit.h>

#include <qcheckbox.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qtooltip.h>
#include <qfile.h>

#include "kompilewidget.h"
#include "kompileinstalledpackagewidget.h"

KompileInstalledPackageWidget::KompileInstalledPackageWidget(KConfig * profile, KDialogBase * parent_dialog, QWidget *parent, const char *name)
    :KompileInstalledWidgetBase(parent, name)
{
  this->profile = profile;
  this->parent = parent_dialog;

  QString profile_name(profile->readEntry("name", ""));
  if (!profile->readEntry("version", "").isEmpty())
    profile_name.append("-" + profile->readEntry("version", ""));
  if (!profile->readEntry("release", ""))
    profile_name.append("-" + profile->readEntry("release", ""));

  lblPackageName->setText("<b>" + profile_name + "</b>");
  lblPackageDesc->setText(profile->readEntry("description", ""));

  btnRepair->setIconSet(KGlobal::iconLoader()->loadIcon("reload", KIcon::Toolbar, 22));
  btnRemove->setIconSet(KGlobal::iconLoader()->loadIcon("trashcan_full", KIcon::Toolbar, 22));

  QFile tarball(profile->readEntry("tarball", ""));
  if (!tarball.exists())
  {
    btnRepair->setEnabled(false);
    QToolTip::add(btnRepair, "Unable to repair package<br>Missing sources tarball.");
    btnRemove->setEnabled(false);
    QToolTip::add(btnRemove, "Unable to remove package<br>Missing sources tarball.");
  }



}

void KompileInstalledPackageWidget::btnRepair_clicked()
{
  int result = KMessageBox::warningYesNo(this, i18n("Now Kompile try to uninstall selected package \"" + lblPackageName->text().remove("<b>").remove("</b>") + "\" and reinstall it.\nIf you are sure that package profile point to a valid source tarball you can proced with repair operation.\nDo you want repair selected package?"), i18n("Repair package"));

  if (result == KMessageBox::No || result == KMessageBox::Cancel)
    return;

  parent->hide();
  KDialogBase * installdialog = new KDialogBase(this, "KompileUninstall", TRUE, tr2i18n("Uninstalling ") + profile->readEntry("tarball", ""), 0);
  KompileWidget * installwidget = new KompileWidget(profile, KompileWidget::OPERATION_UNINSTALL, installdialog);
  installwidget->seconds_left = 1;
  installwidget->chkAutoclose->setChecked(TRUE);
  installwidget->chkAutoclose->setEnabled(FALSE);
  installdialog->setMainWidget( installwidget );
  installdialog->adjustSize();
  installdialog->exec();

  delete installwidget;
  delete installdialog;

  installdialog = new KDialogBase(this, "KompileInstall", TRUE, tr2i18n("Installing ") + profile->readEntry("tarball", ""), 0);
  installwidget = new KompileWidget(profile, KompileWidget::OPERATION_INSTALL, installdialog);
  installwidget->seconds_left = 1;
  installwidget->chkAutoclose->setChecked(TRUE);
  installwidget->chkAutoclose->setEnabled(FALSE);
  installdialog->setMainWidget( installwidget );
  installdialog->adjustSize();
  installdialog->exec();

  delete installwidget;
  delete installdialog;
  parent->show();
}

void KompileInstalledPackageWidget::btnRemove_clicked()
{

  int result = KMessageBox::warningYesNo(this, i18n("Are you sure you want uninstall selected application \"" + lblPackageName->text().remove("<b>").remove("</b>") + "\"?"), i18n("Rollbak package"));

  if (result == KMessageBox::No || result == KMessageBox::Cancel)
    return;

  parent->hide();
  KDialogBase * installdialog = new KDialogBase(this, "KompileUninstall", TRUE, tr2i18n("Uninstalling ") + profile->readEntry("tarball", ""), 0);
  KompileWidget * installwidget = new KompileWidget(profile, KompileWidget::OPERATION_UNINSTALL, installdialog);
  installwidget->seconds_left = 1;
  installwidget->chkAutoclose->setChecked(TRUE);
  installwidget->chkAutoclose->setEnabled(FALSE);
  installdialog->setMainWidget( installwidget );
  installdialog->adjustSize();
  installdialog->exec();

  delete installwidget;
  delete installdialog;
  parent->removeChild(this);
  parent->show();
}





#include "kompileinstalledpackagewidget.moc"
