/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KOMPILEPROFILEWIDGET_H
#define KOMPILEPROFILEWIDGET_H

#include "kompileprofilewidgetbase.h"

class KompileProfileWidget: public KompileProfileWidgetBase
{
  Q_OBJECT

  void init();
  void loadConfigOptions();
  void switchToExpertMode();
  void switchToNormalMode();

public:
  KompileProfileWidget(QWidget *parent = 0, const char *name = 0);
  KompileProfileWidget(QString& profile_name, QWidget *parent = 0, const char *name = 0);

  ~KompileProfileWidget();

  bool saveProfile();
  bool saveDefaultProfile();
  void loadProfile();
  void loadProfile(QString& profile_name);
  KConfig * getProfile();
  QString getProfileFile();

public slots:
  virtual void chkExpertConfiguration_stateChanged(int);
  virtual void bgDecmpress_clicked(int);
  virtual void chkBuilding_toggled(bool);
  virtual void chkNoInstall_toggled(bool);
  virtual void txtCheckinstallDir_textChanged(const QString&);
  virtual void chkPrefix_toggled(bool);
  virtual void btnBrowseInstallationDir_clicked();
  virtual void btnBrowseTarball_clicked();
  virtual void btnFF_clicked();
  virtual void btnCXX_clicked();
  virtual void btnCC_clicked();
  virtual void btnBrowseDecompression_clicked();
  virtual void btnBrowseUserInstallDir_clicked();
  virtual void bgUserChoice_clicked(int);
  virtual void btnLoadDefault_clicked();
  virtual void btnBrowseCheckinstallDir_clicked();
  virtual void txtDecompressionDir_lostFocus();

};

#endif
