/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KOMMANDOVIEW_H
#define KOMMANDOVIEW_H

#include <qlistview.h>

/**
	@author Daniel Stöckel <the_docter@gmx.net>
*/
class KommandoView : public QListView
{
    public:
        KommandoView(QWidget* parent, const QString& name);

        void setAppName(const QString& theValue){ m_AppName = theValue; }
        QString appName() const{ return m_AppName; }

    private:
        QString m_AppName;
};

class KommandoViewList : public QPtrList<KommandoView>
{
    public:
        KommandoViewList(bool autoDelete = false);

        bool contains(const QString& view);

        KommandoView* getView(const QString& view);
        KommandoView* getViewOrDefault(const QString& view);
        void removeView(const QString& view);

};

#endif
