/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef LDAPSEARCHDIALOG_H
#define LDAPSEARCHDIALOG_H

#include "qldap.h"

#include <QtGui/QDialog>

class LdapSearchDialog : public QDialog
{
  Q_OBJECT

  public:
    LdapSearchDialog( QLdap* connection, QWidget *parent = 0 );
    ~LdapSearchDialog();

    /**
     * Sets the filter for this search.
     *
     * The filter can be any LDAP filter with %i as replacement
     * for the input of the user.
     *
     * Example:
     *   setSearchFilter( "(|(uid=%i)(mail=%i))" )
     */
    void setSearchFilter( const QString &searchFilter );

    /**
     * Sets the display format.
     *
     * The display format is used in the result view to
     * reformat the entries.
     *
     * Example:
     *   setDisplayFormat( "%givenName% %sn%" );
     */
    void setDisplayFormat( const QString &displayFormat );

    void setBlackList( const QStringList &blacklist );

    /**
     * Returns a list of values for the given key the user selected.
     *
     * Example:
     *   QStringList emails = dlg.selectedValues( "mail" );
     *
     *    will return the email addresses of all selected entries
     */
    QStringList selectedValues( const QString& key ) const;

    /**
     * Returns a list of all selected ldap entries.
     */
    QLdapEntry::List selectedEntries() const;

  public slots:
    void search();

  private:
    class Private;
    Private *d;
};


#endif
