/***************************************************************************
                          dlg_server.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kicontheme.h>
#include "dlg_server.moc"

dlg_server::dlg_server(QWidget *parent, const char *name, resource *Rsrc, QString ItemName ) :
	KDialogBase(	parent,
								name,						
								TRUE,
								i18n("Configure Server"),
								Help|Ok|Apply|Cancel,
								Ok,		
								TRUE )
{
	Resource = Rsrc;
	Name = ItemName;

	BOX_Parent = makeVBoxMainWidget();
	
	BOX_Name = new QGroupBox( 1,
														Qt::Horizontal,
														i18n( "Server Name" ),
														BOX_Parent );
	EDIT_Name = new KLineEdit( BOX_Name );
	
	BOX_URLPort = new QHBox( BOX_Parent );
	BOX_URL = new QGroupBox( 1,
																Qt::Horizontal,
																i18n( "Server URL" ),
																BOX_URLPort );
	EDIT_URL = new KLineEdit( BOX_URL );
	BOX_Port = new QGroupBox( 1,
																Qt::Horizontal,
																i18n( "Server Port" ),
																BOX_URLPort );
	EDIT_Port = new KLineEdit( BOX_Port );
	
	BOX_UNameStore = new QHBox( BOX_Parent );
	BOX_UserName = new QGroupBox( 1,
																	Qt::Horizontal,
																	i18n( "Username" ),
																	BOX_UNameStore );
	EDIT_UserName = new KLineEdit( BOX_UserName );
	CHECK_StorePass = new QCheckBox( i18n( "Remember My Password" ), BOX_UNameStore );
	
	BOX_Pass = new QHBox( BOX_Parent );
	BOX_Password = new QGroupBox( 1,
																	Qt::Vertical,
																	i18n( "Password" ),
																	BOX_Pass );
	EDIT_Password = new KLineEdit( BOX_Password );
	EDIT_Password->setEchoMode( QLineEdit::Password );
	
	BOX_PasswordRetype = new QGroupBox( 1,
																	Qt::Vertical,
																	i18n( "Confirm Password" ),
																	BOX_Pass );
	EDIT_PasswordRetype = new KLineEdit( BOX_PasswordRetype );
	EDIT_PasswordRetype->setEchoMode( QLineEdit::Password );
	
	/* Use Timeseal? */
	GROUP_Timeseal = new QGroupBox( 2,
																		Qt::Horizontal,
																		i18n( "Timeseal" ),
																		BOX_Parent );
	EDIT_Timeseal = new KLineEdit( GROUP_Timeseal );
	BUTTON_Timeseal = new QPushButton( GROUP_Timeseal );
	BUTTON_Timeseal->setPixmap( Resource->LoadIcon( QString( "fileopen" ), KIcon::Toolbar ) );
	connect( BUTTON_Timeseal, SIGNAL( clicked() ), this, SLOT( slot_Timeseal() ) );

	BOX_LogFile = new QGroupBox( 2,
																Qt::Horizontal,
																i18n( "Log File" ),
																BOX_Parent );
	EDIT_LogFile = new KLineEdit( BOX_LogFile );
	BUTTON_LogFile = new QPushButton( BOX_LogFile );
	
	setMainWidget( BOX_Parent );
	BUTTON_LogFile->setPixmap( Resource->LoadIcon( QString( "fileopen" ), KIcon::Toolbar ) );
	EDIT_Name->setMinimumWidth( 120 );
	EDIT_URL->setMinimumWidth( 120 );
	EDIT_UserName->setMinimumWidth( 120 );
	EDIT_Password->setMinimumWidth( 120 );
	EDIT_PasswordRetype->setMinimumWidth( 120 );
	/* Load in data if this is a modification */
	if( !Name.isEmpty() )
	{
		for ( serversIT = Resource->servers.begin(); serversIT != Resource->servers.end(); ++serversIT )
		{
			if( (*serversIT).Name == Name ) break;
		}
		EDIT_Name->setText( (*serversIT).Name );
		EDIT_URL->setText( (*serversIT).URL );
		EDIT_Port->setText( QString("").setNum( (*serversIT).Port ) );
		EDIT_UserName->setText( (*serversIT).UserName );
		CHECK_StorePass->setChecked( (*serversIT).StorePass );
		EDIT_Password->setText( (*serversIT).Password );
		EDIT_PasswordRetype->setText( (*serversIT).Password );
		EDIT_LogFile->setText( (*serversIT).LogFile );
		EDIT_Timeseal->setText( (*serversIT).Timeseal );
	}
	if( CHECK_StorePass->isChecked() )
	{
		EDIT_Password->setEnabled( TRUE );
		EDIT_PasswordRetype->setEnabled( TRUE );
	}
	else
	{
		EDIT_Password->setEnabled( FALSE );
		EDIT_PasswordRetype->setEnabled( FALSE );
	}
	/* Init the buttons */
	showButtonCancel( TRUE );
	showButtonOK( TRUE );
	showButtonApply( TRUE );
	showButton( Help, TRUE );

	enableButtonCancel( TRUE );
	enableButtonOK( TRUE );
	enableButtonApply( FALSE );
	enableButton( Help, TRUE );

	setHelp( QString( "configure-servers" ) );
	/* Make Connections */
	connect( BUTTON_LogFile, SIGNAL( clicked() ), this, SLOT( slotLogFileDialog() ) );
	connect( CHECK_StorePass, SIGNAL( toggled(bool) ), this, SLOT( slotStorePass(bool) ) );
	connect( EDIT_Name, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	connect( EDIT_URL, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	connect( EDIT_Port, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	connect( EDIT_UserName, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	connect( EDIT_Password, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	connect( EDIT_Timeseal, SIGNAL( textChanged( const QString&) ), this, SLOT( slotEnableApply( const QString&) ) );
	show();
}
dlg_server::~dlg_server()
{
}

void dlg_server::slotOk( void )
{
	slotApply();
	slotDelayedDestruct();
}

void dlg_server::slotApply( void )
{
	serverResource newServer;

	if( ( EDIT_Password->text() != EDIT_PasswordRetype->text() ) && ( CHECK_StorePass->isChecked() ) )
	{
		return;
	}
	if( Name.isEmpty() )
	{
		serversIT = Resource->servers.append( newServer );
		Name = "notemptyanymore";
		(*serversIT).CurrentRef = 0;
	}
	(*serversIT).Name = EDIT_Name->text();
	(*serversIT).URL = EDIT_URL->text();
	(*serversIT).Port = QString( EDIT_Port->text() ).toInt();
	(*serversIT).UserName = EDIT_UserName->text();
	(*serversIT).Password = EDIT_Password->text();
	(*serversIT).LogFile = EDIT_LogFile->text();
	(*serversIT).StorePass = CHECK_StorePass->isChecked();
	(*serversIT).Timeseal = EDIT_Timeseal->text();
	
	enableButtonApply( FALSE );
}

void dlg_server::slotCancel( void )
{
	slotDelayedDestruct();
}

void dlg_server::slotLogFileDialog( void )
{
	QString temp;

	temp = KFileDialog::getOpenFileName(	QString::null,
																				QString( "*" ),
																				this,
																				QString( "Find Log..." ) );
	if( temp.isEmpty() ) return;
	EDIT_LogFile->setText( temp );
	enableButtonApply( TRUE );
}

void dlg_server::slotEnableApply( const QString& )
{
	enableButtonApply( TRUE );
}

void dlg_server::slotStorePass( bool )
{
	if( CHECK_StorePass->isChecked() )
	{
		EDIT_Password->setEnabled( TRUE );
		EDIT_PasswordRetype->setEnabled( TRUE );
	}
	else
	{
		EDIT_Password->setEnabled( FALSE );
		EDIT_PasswordRetype->setEnabled( FALSE );
	}
	enableButtonApply( TRUE );
}
///////////////////////////////////////
//
//	dlg_server::slot_Timeseal
//
///////////////////////////////////////
void dlg_server::slot_Timeseal( void )
{
	QString temp;

	temp = KFileDialog::getOpenFileName(	QString::null,
																				QString( "*" ),
																				0,
																				QString( "Find Timeseal..." ) );
	if( temp.isEmpty() ) return;
	EDIT_Timeseal->setText( temp );
	enableButtonApply( TRUE );
}

