/***************************************************************************
 *   Copyright (C) 2007 by Todor Gyumyushev   *
 *   yodor@developer.bg   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ALARMSDIALOG_H
#define ALARMSDIALOG_H

#include "alarms.h"
#include "knetdockif.h"

class AlarmsDialog : public AlarmsWidget
{
  Q_OBJECT

public:
  AlarmsDialog(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~AlarmsDialog();
	void update(const KNetDockIf *nif);

public slots:
	void readAlarm();
	void saveAlarm();
	void toggleEnabled(bool);
	void qntyChanged(int);
	
private:
	QString dev_name;
	bool alarmEnabled;
	double traffic;
	int qntIndex;
	bool alarmExec;
	Q_ULLONG m_bytes;
	bool testAlarm();
};

#endif

