//
// C++ Implementation: kmfruleoptioneditiip
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kmfruletargetoptionedittos.h"


// QT includes
#include <qstring.h>

// KDE includes
#include <kdebug.h>
#include <klocale.h>

// Project includes
#include "../../core/iptrule.h"
#include "../../core/kmfruleeditinterface.h"
#include "kmfruleeditortos.h"

namespace KMF {
KMFRuleTargetOptionEditTos::KMFRuleTargetOptionEditTos(QObject *parent, const char *name)
		: KMFRuleTargetOptionEditInterface(parent, name) {
	kdDebug() <<"KMFRuleTargetOptionEditTos::KMFRuleTargetOptionEditTos(QObject *parent, const char *name)" << endl;
	
	m_managedTargets << "TOS" << "REJECT";
	
	
	kdDebug() << "Parent has Type: " << parent->className()  << endl;
	
	m_edit = new KMFRuleEditorTos( 0 , "Edit", 0 );
	m_edit->hide();

	connect( m_edit,SIGNAL(sigHideMe() ), 
		this,SLOT( slotShowOverview() ) );
}

KMFRuleTargetOptionEditTos::~KMFRuleTargetOptionEditTos() {}

void KMFRuleTargetOptionEditTos::slotShowOverview() {
	if ( KMFRuleEditInterface* ruleedit = dynamic_cast<KMFRuleEditInterface*> ( parent() ) ) {
		ruleedit->showOverview();
	} else {
		kdDebug() << "KMFRuleTargetOptionEditTos::slotShowOverview(): parent() not of type KMFRuleEditInterface" << endl;
	}
}

const QString& KMFRuleTargetOptionEditTos::optionEditName() const {
	return *( new QString( i18n("Protocol Option") ) );
}
const QString& KMFRuleTargetOptionEditTos::description() const {
	return *( new QString( i18n("This plugin manages the Protocol based options of iptables.") ) );
}

void KMFRuleTargetOptionEditTos::loadRule( IPTRule* rule ) {
	if ( !rule ) {
		kdDebug() << "KMFRuleTargetOptionEditTos::loadRule( IPTRule* rule ) - rule == 0" << endl;
		return;
	}
	
	m_edit->loadRule( rule );
	m_rule = rule;

}

QWidget* KMFRuleTargetOptionEditTos::editWidget() {
	if ( ! m_edit ) {
		kdDebug() << "KMFRuleTargetOptionEditTos::editWidget() - m_edit == 0" << endl;
		return 0;
	}
	return m_edit;
}

bool KMFRuleTargetOptionEditTos::setTarget( const QString& target ){
	if ( ! manageTarget( target ) ) {
		return false;
	}
	if ( target == "TOS") 
		m_edit->setType( "SETTOS" );
	else 
		m_edit->setType( "REJECTTYPE" );
	return true;
}



// It's usually safe to leave the factory code alone.. with the
// notable exception of the KAboutData data
#include <kaboutdata.h>
#include <klocale.h>

// KInstance* KMFRuleTargetOptionEditTosFactory::s_instance = 0L;
// KAboutData* KMFRuleTargetOptionEditTosFactory::s_about = 0L;

KMFRuleTargetOptionEditTosFactory::KMFRuleTargetOptionEditTosFactory( QObject* parent, const char* name )
		: KLibFactory( parent, name ) {
// 	s_instance = new KInstance( "KMFRuleTargetOptionEditTosFactory" );
}

QObject* KMFRuleTargetOptionEditTosFactory::createObject( QObject* parent, const char* name,
        const char*, const QStringList & ) {
	QObject * obj = new KMFRuleTargetOptionEditTos( parent, name );
	emit objectCreated( obj );
	return obj;
}


// KInstance* KMFRuleTargetOptionEditTosFactory::instance() {
// 	if ( !s_instance ) {
// 		s_instance = new KInstance( "KMFRuleTargetOptionEditTosFactory" );
// 	}
// 	return s_instance;
// }

extern "C" {
	void* init_libkmfruletargetoptionedit_tos() {
		return new KMFRuleTargetOptionEditTosFactory;
	}
}


}

#include "kmfruletargetoptionedittos.moc"
