//
// C++ Interface: kmfgenericinterfaceeditprotocol
//
// Description:
//
//
// Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KMFGENERICINTERFACEEDITPROTOCOL_H
#define KMFGENERICINTERFACEEDITPROTOCOL_H

#include "kmyfirewallgenericinterfaceeditprotocolwidget.h"

// QT Includes
#include <qptrlist.h>
#include <qstring.h>
#include <qguardedptr.h>
#include <qpixmap.h>

/**
@author Christian Hubinger
*/

class QListViewItem;
class QListBoxItem;

namespace KMF {
class KMFGenericDoc;
class KMFNetwork;
class KMFProtocol;
class KMFListViewItem;
class KMFProtocolCategory;

class KMFGenericInterfaceEditProtocol : public KMyFirewallGenericInterfaceEditProtocolWidget {
	Q_OBJECT
public:
	KMFGenericInterfaceEditProtocol( QWidget *parent = 0, const char *name = 0, WFlags f = 0 );

	~KMFGenericInterfaceEditProtocol();

	void saveProtocols();
	// void loadProtocols();
	
public slots:
	void slotUpdateView();

protected slots:
	void slotNewItemSelected( QListViewItem* );
	void slotCurrentTCPPortChanged( QListBoxItem * );
	void slotCurrentUDPPortChanged( QListBoxItem * );
	void slotPortVauleChanged( int );
	void slotProtocolChanged();
	void slotNameDescritionChanged();
	void slotProtocolTypeChanged();
	void slotAddPort();
	void slotDelPort();
	void slotAddProtocol();
	void slotDelProtocol();
	void slotOnProtocolDeleleted( QObject* );
public:
	void loadDoc( KMFNetwork* );

private: // Methods
	
	void updateEdit();
	const QString& getXMLSniplet();
//	KMFProtocolCategory* getCuustomCategotry();
	
private: // DATA
	KMFNetwork *m_network;
	// QPtrList<KMFProtocol> m_protocols;
	QGuardedPtr<KMFProtocol> m_protocol;
	// bool m_protocolsLoaded;
	
};
}
#endif
