/***************************************************************************
 *   Copyright (C) 2004 by Spiros Georgaras                                *
 *   sngeorgaras@otenet.gr                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MHT_H
#define MHT_H

#include <iostream>
#include <kmimetype.h>
#include <ksharedptr.h>
#include <kmdcodec.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <ktempdir.h> 
#include <kstandarddirs.h>
#include <qstring.h>
#include <qfile.h>
#include <ktar.h>
#include <krun.h>
#include <qcstring.h>
#include <qdatastream.h>
#include <qtextstream.h> 
#include <qdir.h>
#include <qfile.h>
#include <qregexp.h>
#include <qobject.h>
#include <kdebug.h>

#include "kmhtmlarchive.h"
class MHT: public QObject{
Q_OBJECT
public:
	MHT();
	~MHT();
	bool setFile(QString fileName,QString outDir=QString::null, bool hInfo=FALSE, bool hAttachments=FALSE);
	bool extractAllFiles();
	QCString getFileContents(int id);
	uint getEncodedSize(int id);
	uint getDecodedSize(int id);
	bool createWarArchive();
	bool showWarFile();
	void setViewWarFile(bool view=TRUE);
	void setNoSaveWarFile(bool noSave=FALSE);
	void setSilent(bool sil){beSilent=sil;};
	void setUseGui(bool gui){doUseGui=gui;};
	void reset();
	QCString f;
	QCString boundary;
	int status;
	//0	ok
	//1	input file open error
	//2	no boundary
	//3	no items
	//4	other
	//5	error extracting file
	//6	output file open error
	int items(){return arc->count();};
	void setShowInfo(bool mInfo){arc->setShowInfo(mInfo);};
	void setShowAttachments(bool mAtt){arc->setShowAttachments(mAtt);}; 
signals:
	void archiveOpened();
	void archiveCreated(QString warFileName);
	void errorAppeared(int errorNumber);
	void fileExtraced(QString extractedFileName);
	void foundFilesInArchive(int numOfFiles);
private:
	void getAllNames();
	bool createDir();
	bool extractFiles();
	bool openWarFile(QString fileName);
	bool addFileToWarArchive(int id);
	bool onlyViewWarFile;
	bool dontCreateWarFile;
	QString mhtFileName;
	QString warFileName;
	uint boundaryLength;
	QString TempFolder;
	QString outFolder;
	KTar* m_tarBall;
	bool showed;
	bool created;
	bool beSilent;
	bool doUseGui;
	KmhtmlArchive* arc;
};
#endif
