//KMformat
//by Mickael Minarie
//this program is under GNU/GPL licence

/*! \file ListMountPoint.h
  \brief The class to have the list of the mountpoint can be formatted
    
  The class to have the list of the mountpoint can be formatted
  I use the file /proc/partition to have the list of mount point availlable and the file /proc/diskstats to know if a floppy drive is installed
*/

#ifndef LMP_H
#define LMP_H

#include <QStringList>
#include <QString>
#include <vector>

class ListMountPoint{

 public:
  //! The constructor
  ListMountPoint();

  //! The destructor
  ~ListMountPoint();

  //! to get the list of mount point available
  QStringList GetList();

  //! to get the size of one unit
  QString GetSize(int at);

  //! to get the size of one unit with its name
  QString GetSize(QString unit);

  //! to get the lmountpoint correspond to an int
  QString GetMP(int at);

 protected:   
  //! the list
  QStringList ListPart;

  //! a vector to save the size of each unit
  std::vector<int> vsize;
};

#endif
