/***************************************************************************
                          systemtraywidget.cpp  -  description
                             -------------------
    begin                : Sun Dec 29 2002
    copyright            : (C) 2002 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "systemtraywidget.h"

#include <qtooltip.h>

#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

#include "config.h"
#include "currentaccount.h"


// The constructor
SystemTrayWidget::SystemTrayWidget(QWidget *parent, const char *name )
 : KSystemTray(parent,name)
{
}



// The destructor
SystemTrayWidget::~SystemTrayWidget()
{
#ifdef KMESSDEBUG_SYSTEMTRAY
  kdDebug() << "DESTROYED SystemTrayWidget" << endl;
#endif
}



// Initialize the class
bool SystemTrayWidget::initialize()
{
  CurrentAccount *currentAccount = CurrentAccount::instance();

  connect( currentAccount, SIGNAL(       changedStatus() ),
           this,           SLOT  (       statusChanged() ) );
  connect( currentAccount, SIGNAL(       accountOnline() ),
           this,           SLOT  (       statusChanged() ) );
  connect( currentAccount, SIGNAL(    accountInvisible() ),
           this,           SLOT  (       statusChanged() ) );
  connect( currentAccount, SIGNAL(      accountOffline() ),
           this,           SLOT  (       statusChanged() ) );
  connect( currentAccount, SIGNAL( changedFriendlyName() ),
           this,           SLOT  (       statusChanged() ) );

  // Force changing the icon
  statusChanged();

  return true;
}



// Return the context menu
KPopupMenu* SystemTrayWidget::menu() const
{
  return contextMenu();
}



// Change the icon when the user's status changes
void SystemTrayWidget::statusChanged()
{
  QString     status;
  QString     newTooltip;
  QString     iconName, statusName;
  KIconLoader *loader = KGlobal::iconLoader();
  CurrentAccount *currentAccount = CurrentAccount::instance();

  status = currentAccount->getStatus();

  // Update the onlineStatusLabel
  if ( status == "AWY" )
  {
    iconName = "away";
    statusName = i18n("Away");
  }
  else if ( status == "BRB" )
  {
    iconName = "berightback";
    statusName = i18n("Be Right Back");
  }
  else if ( status == "BSY" )
  {
    iconName = "busy";
    statusName = i18n("Busy");
  }
  else if ( status == "FLN" )
  {
    iconName = "offline";
    statusName = i18n("Offline");
  }
  else if ( status == "HDN" )
  {
    iconName = "invisible";
    statusName = i18n("Invisible");
  }
  else if ( status == "IDL" )
  {
    iconName = "away";
    statusName = i18n("Idle");
  }
  else if ( status == "LUN" )
  {
    iconName = "lunch";
    statusName = i18n("Out to Lunch");
  }
  else if ( status == "NLN" )
  {
    iconName = "online";
    statusName = i18n("Online");
  }
  else if ( status == "PHN" )
  {
    iconName = "onthephone";
    statusName = i18n("On the Phone");
  }
  else
  {
    kdWarning() << "SystemTrayWidget::statusChanged() - The account had an invalid status: " << status << "." << endl;
    return;
  }

  // Update the icon
  setPixmap( loader->loadIcon( iconName, KIcon::User ) );

  // Change the tooltip
  QToolTip::remove( this );

  newTooltip = i18n( "%1 %2" ).arg( I18N_NOOP("KMess") ).arg ( VERSION );

  if( status != "FLN" )
  {
    newTooltip += i18n( "<br><b>%1</b> (%2)" ).arg( currentAccount->getFriendlyName() ).arg( statusName );
  }

  QToolTip::add( this, newTooltip );
}



#include "systemtraywidget.moc"
