/***************************************************************************
                          transferwindow.h -  description
                             -------------------
    begin                : Wed Nov 3 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERMANAGER_H
#define TRANSFERMANAGER_H

#include <kmainwindow.h>

#include <qimage.h>

class TransferEntry;
class TransferWindowInterface;
class QFrame;
class QScrollView;
class QVBoxLayout;

/**
 * A file transfer manager (aka download manager) singleton.
 * @author Diederik van der Boor
 */
class TransferWindow : public KMainWindow
{
  Q_OBJECT

  private:
    // Constructor
                               TransferWindow( QWidget *parent = 0 );
    // Destructor
                              ~TransferWindow();

  public:
    // Add a new entry
    int                        addEntry( const QString filename, uint filesize, bool incoming = false,
                                         const QImage preview = QImage() );
    // Destroy the current instance
    static void                destroy();
    // Return an instance of the transfer manager
    static TransferWindow     *getInstance();

  public slots:
    // Mark a transfer as failed
    void                       failTransfer( int transferID, const QString &message = QString::null );
    // Mark a transfer as complete
    void                       finishTransfer( int transferID );
    // Set the status message of a transfer
    void                       setStatusMessage( int transferID, const QString &message );
    // Update the progress bar of a transfer
    void                       updateProgress( int transferID, uint bytesTransferred );

  private slots:
    // The "Clean up" button was pressed.
    void                       cleanUp();

  signals:
    // Emit a request to cancel a transfer
    void                       cancelTransfer( int transferID );

  private:
    // Counter used to generate unique transfer IDs
    static int                 currentEntryID_;
    // Instance to the singleton
    static TransferWindow     *onlyInstance_;

  private:
    // List of all entries
    QMap<int,TransferEntry*>   entryList_;
    // Interface of the Transfer Window GUI
    TransferWindowInterface   *interface_;
    // Main widget for entries
    QWidget                   *mainWidgets_;
    // Layout manager
    QVBoxLayout               *mainLayout_;
};

#endif
