/***************************************************************************
                          emoticonsidebar.h -  description
                             -------------------
    begin                : Mon 12 09 2005
    copyright            : (C) 2005 by Diederik van der Boor
    email                : "vdboor" --at-- "codingdomain.com"
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EMOTICONSIDEBAR_H
#define EMOTICONSIDEBAR_H

#include <qvbox.h>
#include <qwidget.h>

class Emoticon;
class EmoticonManager;
class QResizeEvent;
class QSpacerItem;

/**
 * Implements an emoticon chooser as sidebar tab.
 *
 * @author Diederik van der Boor, Valerio Pilo
 */
class EmoticonSidebar : public QVBox
{
  Q_OBJECT

  public:
    // The constructor
                       EmoticonSidebar( QWidget *parent, const char *name, bool useCustomTheme );
    // The destructor
    virtual           ~EmoticonSidebar();

  protected slots:
    // Overwritten method to detect resizes
    virtual void       resizeEvent(QResizeEvent*);

  private slots:
    // A button was clicked
    void               slotInsertEmoticon(QString html);
    // The theme has changed, we need to reload it
    void               slotThemeUpdated();

  private:   // private methods
    // Create an emoticon button on the grid
    void               createEmoticonButton(const Emoticon *emoticon);
    // Layout the emoticon buttons
    void               updateEmoticonLayout();

  private:  // private properties
    // Current number of columns used by the grid
    int                cols_;
    // Grid which will lay our emoticon buttons out
    QGrid             *grid_;
    // Whether the sidebar contains a standard or custom theme
    bool               isCustom_;
    // Reference to the emoticon manager, to update the emoticon buttons
    EmoticonManager   *manager_;
    // A spacer used to keep the emoticons grid at the top of the sidebar
    QSpacerItem       *spacer_;

  signals: // Signals
    // Request that the emoticon's html code should be inserted in the message.
    void               insertEmoticon(QString html);
};

#endif
