/*		Name:		timeout.c
		Version:	0.0.1
		Date:		19/6/2003
		File descriptor timeout check w/o using poll
*/

#include "timeout.h"
#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>
#include <unistd.h>

/* fd_ready : returns 1 on file descriptor ready to input (is_read != 0)/won't block on
	write (is_read == 0), 0 when the timeout is reached. The timeout is specified in milliseconds
	and means `forever' if negative */ 
int fd_ready (int fd, int is_read, int ms_timeout)
{
		int select_retval;
		fd_set timeout_fd_set;
		struct timeval timeout_timeval, *used_timeout;
		FD_ZERO (&timeout_fd_set);
		FD_SET (fd, &timeout_fd_set);

		if (ms_timeout < 0)
		{
			used_timeout = NULL;
		} else {
			timeout_timeval.tv_sec = ms_timeout / 1000;
			timeout_timeval.tv_usec = (ms_timeout % 1000) * 1000;
			used_timeout = &timeout_timeval;
		}

		select_retval = select (fd + 1, (is_read ? &timeout_fd_set : NULL),
			(is_read ? NULL : &timeout_fd_set), NULL, used_timeout);

		return select_retval > 0;
}
