/***************************************************************************
 *   Copyright (C) 2007 by xes                                             *
 *   pinon.pierre@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINOBJ_H
#define MAINOBJ_H

#include "confWindow.h"
#include "mainWindow.h"
#include "klogshow.h"

class mainObj : public QObject
{
		Q_OBJECT
	public:
		mainObj ( QString appFileName, QString confFileName, bool startByApp, QObject *parent = 0 );
		~mainObj();
		QString			getConfPath();
	private slots:
		void				menuConfig_triggered();
		void				menuAbout_triggered();
		void				menuAboutQt_triggered();
		void				menuQuit_triggered();
		void				activateCheck_stateChanged();
		void				formlog_rejected();
		void				formconf_rejected();
	private:
		bool				startFormlog ( mainWindow *form );
		void				startFormslog();
		void				stopFormslog();
		QWidgetAction*		makeTitreMenu ( QString titre, QString icon, QWidget * parent = 0 );
		QMenu*			makeSystray();

		QString			confPath;
		QSystemTrayIcon	*systray;
		QMenu			*menu;
		QMenu			*menuEnabled;
		QAction			*menuConfig;
		QAction			*menuAbout;
		QAction			*menuAboutQt;
		QAction			*menuQuit;
		QCheckBox			*activateCheck[MAX_FILES];
		mainWindow		*formlog[MAX_FILES];
		confWindow		*formconf;
		int				nbrFormlog;
};

#endif
