#include <qpainter.h>
#include "deviceSimple.h"
#include "connection.h"

// simple device with same operation for all input and common output
SimpleDevice::SimpleDevice(int iFunction, const QPoint& oPos, int iSize)
	: XDevice(iFunction, oPos, iSize),
	  m_oCalc(this, Global::Device::getUndefinedValue(), Global::Device::getDelay())
{
}

SimpleDevice::~SimpleDevice()
{
}

void SimpleDevice::init()
{
	XDevice::init();
}

bool SimpleDevice::hasNamedInput() const
{
	return false;
}

bool SimpleDevice::hasNamedOutput() const
{
	return false;
}

void SimpleDevice::setEquation()
{
	switch(type()) {
		case DeviceType::fONE:
			m_oCalc.setEquation(Operator::OR);
			break;
		case DeviceType::fXOR:
			m_oCalc.setEquation(Operator::XOR);
			break;
		case DeviceType::fAND:
			m_oCalc.setEquation(Operator::AND);
			break;
		case DeviceType::fOR:
			m_oCalc.setEquation(Operator::OR);
			break;
		default:
			m_oCalc.setEquation(Operator::OR);
			break;
	}
}

// virtual, create a new image if not in cache already
Image * SimpleDevice::createImage(const ImageKey& oKey)
{
	Image *poImage = m_oImageCache.getNewImage();
	const Image *part = 0;
	QPainter p;
	QPoint pt(0,0);
	QPoint pp(15,35);

	// first resize the device pixmap, assign the base image to "part"..
	if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900 ||
			(type() != DeviceType::fAND && type() != DeviceType::fOR &&
			 type() != DeviceType::fXOR && type() != DeviceType::fONE)) {
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP);
		int iHeight = part->height();
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID);
		iHeight += part->height() * size();
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT);
		iHeight += part->height();
		poImage->resize(part->width(), iHeight);
	} else {
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP_BLANK);
		int iHeight = part->height();
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_BLANK);
		iHeight += part->height() * size();
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_BLANK);
		iHeight += part->height();
		poImage->resize(part->width(), iHeight);
	}

	p.begin(poImage);

	// ..then draw the device image
	if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900 ||
			(type() != DeviceType::fAND && type() != DeviceType::fOR &&
			 type() != DeviceType::fXOR && type() != DeviceType::fONE)) {
		// top of the device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_TOP);
		p.drawPixmap(pt, *part);
		pt.setY(pt.y() + part->height());

		// middle-part of device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID);
		for(int i = 0; i < size(); i++) {
			p.drawPixmap(pt, *part);
			pt.setY(pt.y() + part->height());
		}

		// bottom of device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT);
		p.drawPixmap(pt, *part);
	} else {
		// top of the device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_BLANK);
		p.drawPixmap(pt, *part);
		pt.setY(pt.y() + part->height());

		// middle-part of device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_MID_BLANK);
		for(int i = 0; i < size(); i++) {
			p.drawPixmap(pt, *part);
			pt.setY(pt.y() + part->height());
		}

		// bottom of device
		part = m_oBasicImageCache.getImage(BasicImageCache::BODY_BOT_BLANK);
		p.drawPixmap(pt, *part);
	}

	// draw symbol
	switch(oKey.getType()) {
		case DeviceType::fAND:
			if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900)
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_AND);
			else
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_IECAND);
			pp.setX(poImage->width()/2 - part->width()/2);
			pp.setY(poImage->height()/2 - part->height()/2);
			p.drawPixmap(pp, *part);
			break;
		case DeviceType::fOR:
			if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900)
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_OR);
			else
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_IECOR);

			pp.setX(poImage->width()/2 - part->width()/2);
			pp.setY(poImage->height()/2 - part->height()/2);
			p.drawPixmap(pp, *part);
			break;
		case DeviceType::fXOR:
			if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900)
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_XOR);
			else
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_IECXOR);
			pp.setX(poImage->width()/2 - part->width()/2);
			pp.setY(poImage->height()/2 - part->height()/2);
			p.drawPixmap(pp, *part);
			break;
		case DeviceType::fONE:
			if (Global::Device::getSymbolSet() == Global::Device::SYMBOLSET_DIN40900)
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_NOT);
			else
				part = m_oBasicImageCache.getImage(BasicImageCache::SYMBOL_IECNOT);
			pp.setX(poImage->width()/2 - part->width()/2);
			pp.setY(poImage->height()/2 - part->height()/2);
			p.drawPixmap(pp, *part);
			break;
		default:
			break;
	}
	return poImage;
}

void SimpleDevice::setOutputValue(int, int iValue)
{
	if (m_oCalc.getResult() != iValue) {
		m_oCalc.flush(iValue);
		m_iLastResult = m_iCurrentResult;
		m_iCurrentResult = iValue;
		return;
	}
}

void SimpleDevice::setUndefinedValue(int iUndefinedValue)
{
	m_oCalc.setUndefinedValue(iUndefinedValue);
}

int SimpleDevice::getUndefinedValue() const
{
	return m_oCalc.getUndefinedValue();
}

int SimpleDevice::output(int)
{
	return m_oCalc.getResult();
}

void SimpleDevice::flush(int value)
{
	m_oCalc.flush(value);
}

void SimpleDevice::forceOutputChange()
{
	m_bForceOutputChange = true;
}

bool SimpleDevice::outputChanged()
{
	if (m_bForceOutputChange)
		return true;
	if (m_iCurrentResult != m_iLastResult)
		return true;
	return false;
}

// calculate new output-values (currently, always only old values are reachable)
void SimpleDevice::Calculate(int)
{

	// determine new output value
	if (!inputChanged())
		return;

	for (ConnectionList::iterator iter = m_poConnectionList->begin(); iter != m_poConnectionList->end(); iter++)
		m_oCalc.push((*iter)->getInput());

	// calculate new output value
	m_oCalc.calculate(false);
}

void SimpleDevice::Propagate(int burst_step)
{
	if (m_bForceOutputChange) {
		m_iCurrentResult = 1;
		m_iLastResult = 0;
		m_bForceOutputChange = false;
		m_oCalc.shift();
	} else {
		if (!burst_step)
			m_iLastResult = m_oCalc.shift();	// first burst_step
		m_iCurrentResult = m_oCalc.getResult();
	}
}

void SimpleDevice::setEquation(char cEquation)
{
	m_oCalc.setEquation(cEquation);
}

QueueInfo SimpleDevice::parseEquation()
{
	return m_oCalc.parse();
}
