/*
 *  Klavier : Virtual keyboard for K Destop Environement
 *
 *  This program (klavier) is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 *  This program (klavier) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 * License along with this program (klavier); if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA. 
 *
 * Author : Sebastien HUSS <sebastien.huss@laposte.net>
 *
 */
#ifndef PUSHKEY_H
#define PUSHKEY_H

#include <qpushbutton.h>
#include <qsize.h>
#include "sendkey.h"


/**
	@author Sebastien HUSS <sebastien.huss@laposte.net>
*/
class PushKey : public QPushButton
{
//	Q_OBJECT

	public:
		PushKey(sendKey * wire, const KeyCode mycode, QWidget * parent = 0, const char * name = 0);

    /**
	 * Default Destructor
     */
		virtual ~PushKey();

		void	setLogicalCoord(const int x, const int y);
		void	resizeToLogical(const QSize & size);
	protected:
		sendKey	*	wire;
		KeyCode		code;
	private:
		int		lx;
		int		ly;

		void		setLabel();
		string		getIconName(KeyCode kc);
};

#endif
