/***************************************************************************
 *   Copyright (C) 2004 by Leonid Zeitlin                                  *
 *   lz@europe.com                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "singlewindowwatcher.h"
#include "kbconfig.h"

#include <kwinmodule.h>
#include <kdebug.h>

SingleWindowWatcher::SingleWindowWatcher(KBConfig *kbconf, QObject *parent, const char *name)
 : WindowWatcher(kbconf, parent, name)
{
  reset();
}

SingleWindowWatcher::~SingleWindowWatcher()
{
}

void SingleWindowWatcher::windowRemoved(WId id)
{
  m_window_map.remove(id);
}

void SingleWindowWatcher::activeWindowChanged(WId id)
{
  if (id == 0) return; // no window is active
  m_active_window = m_window_map.find(id);
  if (m_active_window == m_window_map.end())
    addWindowToMap(id);
  emit windowChanged(m_active_window.data().groupno, m_active_window.data().next_groupno);
}

void SingleWindowWatcher::addWindowToMap(WId window_id)
{
  KBWinInfo wininfo = { m_kbconf->default_groupno(),
    m_kbconf->getNextGroup(m_kbconf->default_groupno()) };

  m_active_window = m_window_map.insert(window_id, wininfo);
}

void SingleWindowWatcher::changeGroup(int groupno, int next_groupno)
{
  if (m_active_window != m_window_map.end()) {
    m_active_window.data().groupno = groupno;
    m_active_window.data().next_groupno = next_groupno;
  }  
}

void SingleWindowWatcher::reset()
{
  m_window_map.clear();
  WId active_window = m_kwin_module->activeWindow();
  if (active_window)
    addWindowToMap(active_window);
  else m_active_window = m_window_map.end();
}
