#ifndef KP_LOG_STAT_ITEM_H_
#define KP_LOG_STAT_ITEM_H_

#include "kpsplitworkout.h"
#include "kpsplit.h"


typedef enum {    
  KP_PERIOD_DAY,
  KP_PERIOD_WEEK,
  KP_PERIOD_MONTH,
  KP_PERIOD_YEAR,
  KP_PERIOD_ALL_TIME
} KPLogStatPeriod;



typedef struct KPLogStatItem_ {
  KPLogStatPeriod       period;
  gchar                *sport;
  gchar                *intensity;

  guint                 days_in_period;
  guint                 n_workouts;
  guint                 n_entries;
                                                    
  guint                 tot_du;
  guint                 avg_du;
  guint                 max_du;
  guint                 min_du;

  gdouble               tot_di;
  gdouble               avg_di;
  gdouble               max_di;
  gdouble               min_di;
} KPLogStatItem;


#include "kplogstat.h"

KPLogStatItem     *kp_log_stat_item_new                 (KPLogStatPeriod period,
                                                         const gchar *sport,
                                                         const gchar *intensity);
void               kp_log_stat_item_add_workout         (KPLogStatItem *item,
                                                         KPWorkout *wo);
void               kp_log_stat_item_add_item            (KPLogStatItem *dest,
                                                         KPLogStatItem *src);
void               kp_log_stat_item_free                (KPLogStatItem *item);


#endif
