#ifndef KP_LOG_STAT_H_
#define KP_LOG_STAT_H_

#include <libxml/tree.h>
#include <glib.h>
#include <glib-object.h>

#include "kpcalendarentry.h"
#include "kptraininglog.h"
#include "kplogstatitem.h"

#define KP_TYPE_LOG_STAT (kp_log_stat_get_type())
#define KP_LOG_STAT(object) (G_TYPE_CHECK_INSTANCE_CAST ((object), KP_TYPE_LOG_STAT, KPLogStat))
#define KP_LOG_STAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KP_TYPE_LOG_STAT, KPLogStatClass))
#define KP_IS_LOG_STAT(object) (G_TYPE_CHECK_INSTANCE_TYPE ((object), KP_TYPE_LOG_STAT))
#define KP_IS_LOG_STAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KP_TYPE_LOG_STAT))
#define KP_LOG_STAT_GET_CLASS(object) (G_TYPE_INSTANCE_GET_CLASS ((object), KP_TYPE_LOG_STAT, KPLogStatClass))

typedef struct KPLogStat_
{
  KPCalendarEntry    parent_instance;

  /* Private */
  KPTrainingLog *log;
  GHashTable *data;
  GString *buf;
} KPLogStat;



typedef struct KPLogStatClass_ {
  KPCalendarEntryClass parent_class;

  /* Signals */
  /*
  void       (*result_added) (KPLogStat *, guint, KPResult *);
  void       (*result_removed) (KPLogStat *, guint, KPResult *);
*/
} KPLogStatClass;



GType             kp_log_stat_get_type             (void);

KPLogStat        *kp_log_stat_new                  (KPTrainingLog *log);
void              kp_log_stat_load                 (KPLogStat *stat, 
                                                    KPTrainingLog *log);
KPLogStatItem    *kp_log_stat_get_month_stats      (KPLogStat *stat, 
                                                    guint year, 
                                                    guint month,
                                                    const gchar *sport, 
                                                    const gchar *intensity);
KPLogStatItem    *kp_log_stat_get_year_stats       (KPLogStat *stat, 
                                                    guint year, 
                                                    const gchar *sport, 
                                                    const gchar *intensity);
KPLogStatItem   *kp_log_stat_get_stats             (KPLogStat *stat);

#endif
