#include <gconf/gconf-client.h>
#include <glib-object.h>
#include <glib.h>

#include "../kipina-i18n.h"
#include "../kputil.h"

#include "kpviewmodel.h"
#include "kpsidebar.h"

static void         kp_sidebar_class_init         (KPSidebarClass *klass);
static void         kp_sidebar_init               (KPSidebar *bar);
static void         kp_sidebar_finalize           (GObject *object);

typedef struct KPSidebarPrivateData_
{
  GConfClient      *client;

  GtkWidget        *view;
  GtkWidget        *buttons;
} KPSidebarPrivateData;

#define KP_SIDEBAR_PRIVATE_DATA(widget) (((KPSidebarPrivateData*) \
      (KP_SIDEBAR (widget)->private_data)))



GType
kp_sidebar_get_type (void)
{
  static GType        kp_sidebar_type = 0;

  if (!kp_sidebar_type) {
    static const GTypeInfo kp_sidebar_info = {
      sizeof (KPSidebarClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_sidebar_class_init,
      NULL,
      NULL,
      sizeof (KPSidebar),
      0,
      (GInstanceInitFunc) kp_sidebar_init,
      NULL
    };
    kp_sidebar_type = g_type_register_static (GTK_TYPE_VBOX,
                                             "KPSidebar",
                                             &kp_sidebar_info, 0);
  }
  return kp_sidebar_type;
}


static void
kp_sidebar_class_init (KPSidebarClass *klass)
{
  GObjectClass *object_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_sidebar_finalize;
}


static void
kp_sidebar_init (KPSidebar *sb)
{
  KPSidebarPrivateData *p_data;
  GtkWidget *sw;
  
  sb->private_data = g_new (KPSidebarPrivateData, 1);
  p_data = KP_SIDEBAR_PRIVATE_DATA (sb);

  gtk_box_set_spacing (GTK_BOX (sb), 6);

  p_data->buttons = gtk_hbox_new (FALSE, 6);
  gtk_box_pack_end (GTK_BOX (sb), p_data->buttons, FALSE, TRUE, 0);
  gtk_widget_show (p_data->buttons);

  sw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
                                  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start (GTK_BOX (sb), sw, TRUE, TRUE, 0);
  
  p_data->view = gtk_vbox_new (FALSE, 0);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (sw),
                                         p_data->view);
  gtk_widget_show (p_data->view);
  gtk_widget_show (sw);
  
  g_assert (GTK_IS_WIDGET (sb));
  g_assert (GTK_IS_VBOX (sb));
}

static void
kp_sidebar_finalize (GObject *object)
{
  KPSidebarPrivateData *p_data;
  
  p_data = KP_SIDEBAR_PRIVATE_DATA (object);

  g_free (KP_SIDEBAR (object)->private_data);
}

/**
 * kp_sidebar_new:
 * @log: A #KPTrainingLog, can be NULL
 *
 * Create a new instance of #KPSidebar.
 */
GtkWidget *
kp_sidebar_new (void)
{
  return g_object_new (kp_sidebar_get_type (), NULL);
}


  
static void 
mode_button_clicked (GtkButton *button, KPSidebar *sb)
{
  gtk_widget_show (GTK_WIDGET (g_object_get_data (G_OBJECT (button), "widget")));
}

/*
 * Handle this radio button -like behavior for toggle buttons.
 */
static void
mode_button_toggled (GtkToggleButton *button, KPSidebar *sb)
{
  GtkWidget *box;
  GList *list;
  GList *tmp;
  
  if (!gtk_toggle_button_get_active (button))
    return;
    
  box = gtk_widget_get_parent (GTK_WIDGET (button));
  list = gtk_container_get_children (GTK_CONTAINER (box));
  
  while (list) {
    if (list->data != button) {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (list->data), FALSE);
      gtk_widget_hide (GTK_WIDGET (g_object_get_data (list->data, "widget")));
    }
    
    tmp = list;
    list = list->next;
    g_list_free_1 (tmp);
  }
}


/**
 * kp_sidebar_add_widget:
 * @widget: A #GtkWidget
 * @use_expander: Wheter to pack @widget inside GtkExpander
 *
 * 
 */
void
kp_sidebar_add_widget (KPSidebar *sb, GtkWidget *widget, const gchar *title,
                       gboolean use_expander)
{
  KPSidebarPrivateData *p_data;
  GtkWidget *button;

  p_data = KP_SIDEBAR_PRIVATE_DATA (sb);

  button = gtk_toggle_button_new_with_label (title);
  GTK_WIDGET_UNSET_FLAGS (GTK_WIDGET (button), GTK_CAN_FOCUS);

  g_signal_connect (G_OBJECT (button), "clicked",
                    G_CALLBACK (mode_button_clicked), sb);
  g_signal_connect (G_OBJECT (button), "toggled",
                    G_CALLBACK (mode_button_toggled), sb);
  g_object_set_data (G_OBJECT (button), "widget", widget);
  
  gtk_box_pack_start (GTK_BOX (p_data->view), widget, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (p_data->buttons), button, TRUE, TRUE, 0);
  gtk_widget_show (button);
}



