#include <glade/glade.h>
#include <gtk/gtk.h>

#include "kpmainwindow.h"
#include "kpgui.h"

static void   kp_gui_class_init         (GObjectClass *klass, gpointer data);
static void   kp_gui_instance_init      (GObject *object, gpointer data);
static void   kp_gui_instance_finalize  (GObject *object);

KPGui *gui = NULL;

GType
kp_gui_get_type ()
{
  static GType kp_gui_type = 0;

  if (!kp_gui_type) { 
    static const GTypeInfo kp_gui_info = {
      sizeof (KPGuiClass),
      (GBaseInitFunc) NULL,
      (GBaseFinalizeFunc) NULL,
      (GClassInitFunc) kp_gui_class_init,
      (GClassFinalizeFunc) NULL,
      NULL,
      sizeof (KPGui),
      0,
      (GInstanceInitFunc) kp_gui_instance_init,
      NULL
    };

    kp_gui_type = g_type_register_static (G_TYPE_OBJECT, "KPGui", &kp_gui_info, 0);
  }

  return kp_gui_type;
}


static void
kp_gui_class_init (GObjectClass *klass, gpointer data)
{
  GObjectClass *object_class;

  object_class = G_OBJECT_CLASS (klass);
  object_class->finalize = kp_gui_instance_finalize;  
}


static void
kp_gui_instance_init (GObject *object, gpointer data)
{
}


static void
kp_gui_instance_finalize (GObject *object)
{
}


KPGui *
kp_gui_new (void)
{
  return g_object_new (kp_gui_get_type (), NULL);
}



void
kp_gui_init (gint *argc, char ***argv, const gchar *file) 
{
  GtkWidget *window;

  gui = kp_gui_new ();
  
  gtk_init (argc, argv);
  glade_init ();

  window = kp_main_window_new ();
  gtk_widget_show (window);

  kp_main_window_set_log_file (KP_MAIN_WINDOW (window), file);

  gtk_main ();
}


