#ifndef KP_CONTEXTS_H_
#define KP_CONTEXTS_H_

#include <glib.h>
#include <glib-object.h>

typedef enum {
  KP_CONTEXT_WORKOUT              = 0,
  KP_CONTEXT_SPLIT_WORKOUT        = 1,
  KP_CONTEXT_COMMENT              = 2,
  KP_CONTEXT_RESULTS              = 3,
  KP_CONTEXT_CALENDAR_ENTRY       = 4,
  KP_CONTEXT_N                    = 5
} KPContextType;

typedef enum {
  KP_CONTEXT_WORKOUT_FLAG         = (1 << 0),
  KP_CONTEXT_SPLIT_WORKOUT_FLAG   = (1 << 1),
  KP_CONTEXT_COMMENT_FLAG         = (1 << 2),
  KP_CONTEXT_RESULTS_FLAG         = (1 << 3),
  KP_CONTEXT_CALENDAR_ENTRY_FLAG  = (1 << 4),
} KPContextFlags;



typedef struct KPContextItem {
  guint         flags;
  gchar        *title;
  GCallback     cb;
  gchar        *icon;
  gpointer      data;
} KPContextItem;

#define KP_CONTEXT_ITEM(ptr) ((KPContextItem *)ptr)

void    kp_context_init                     (void);
void    kp_context_deinit                   (void);
void    kp_context_add                      (guint flags,
                                             const gchar *title,
                                             GCallback cb,
                                             gpointer data,
                                             const gchar *icon);
void    kp_context_remove                   (KPContextType,
                                             const gchar *title);
GSList *kp_context_get_items                (KPContextType type);
GSList *kp_context_get_menu_items           (guint flags, KPCalendarEntry *entry);



#endif /* KP_CONTEXTS_H_ */
