#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <time.h>

#include "kpmainwindow.h"
#include "kpaddcompetitordialog.h"
#include "kpguiutils.h"

#include "../kptraininglog.h"
#include "../kppresetdata.h"
#include "../kipina-i18n.h"
#include "../kpparamlist.h"
#include "../kpsettings.h"
#include "../kputil.h"
#include "../kpworkout.h"

#define SPORT_MENU_TEXT    "Choose a Sport"
#define SPORT_MENU_OTHER   "Other"

typedef enum {
  KP_ADD_COMPETITOR_DIALOG_MODE_EDIT,
  KP_ADD_COMPETITOR_DIALOG_MODE_NEW    
} KPAddCompetitorDialogMode;

static void     kp_add_competitor_dialog_class_init     (KPAddCompetitorDialogClass *klass);
static void     kp_add_competitor_dialog_init           (KPAddCompetitorDialog *dialog);
static void     kp_add_competitor_dialog_finalize       (GObject *object);

/* Callbacks */
static void     competitor_added                        (GtkButton *button,
                                                         KPAddCompetitorDialog *dialog);

typedef struct KPAddCompetitorDialogPrivateData_
{
  KPResults           *results;

  GtkWidget           *entry_name;
  GtkWidget           *entry_organization;
  GtkWidget           *entry_comment;

  GtkWidget           *duration_h;
  GtkWidget           *duration_m;
  GtkWidget           *duration_s;
  GtkWidget           *duration_t;
  
  GtkWidget           *button_add_comp;
  GtkWidget           *closebutton;
} KPAddCompetitorDialogPrivateData;

#define KP_ADD_COMPETITOR_DIALOG_PRIVATE_DATA(widget) \
  (((KPAddCompetitorDialogPrivateData*) \
  (KP_ADD_COMPETITOR_DIALOG (widget)->private_data)))

static GObjectClass *parent_class = NULL;

GType
kp_add_competitor_dialog_get_type (void)
{
  static GType kp_add_competitor_dialog_type = 0;

  if (kp_add_competitor_dialog_type == 0) {
    static const GTypeInfo our_info = {
      sizeof (KPAddCompetitorDialogClass),
      NULL,
      NULL,
      (GClassInitFunc) kp_add_competitor_dialog_class_init,
      NULL,
      NULL,
      sizeof (KPAddCompetitorDialog),
      0,
      (GInstanceInitFunc) kp_add_competitor_dialog_init,
      NULL,
    };

    kp_add_competitor_dialog_type = g_type_register_static (GTK_TYPE_DIALOG,
                                                    "KPAddCompetitorDialog",
                                                    &our_info, 0);
  }
  return kp_add_competitor_dialog_type;
}


static void
kp_add_competitor_dialog_class_init (KPAddCompetitorDialogClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = g_type_class_peek_parent (klass);
  object_class->finalize = kp_add_competitor_dialog_finalize;
}


static void
kp_add_competitor_dialog_init (KPAddCompetitorDialog *dialog)
{
  KPAddCompetitorDialogPrivateData *p_data;
  GladeXML *xml;

  xml = kp_gui_load ("results", "addcompetitor");
  
  dialog->private_data = g_new0 (KPAddCompetitorDialogPrivateData, 1);
  p_data = KP_ADD_COMPETITOR_DIALOG_PRIVATE_DATA (dialog);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox),
                     KP_W (xml, "addcompetitor"));

  p_data->closebutton = gtk_dialog_add_button (GTK_DIALOG (dialog),
                                               GTK_STOCK_CLOSE,
                                               GTK_RESPONSE_OK);
  g_signal_connect_swapped (G_OBJECT (p_data->closebutton), "clicked",
                            G_CALLBACK (gtk_widget_destroy), dialog);
  
  /* Put widgets to private data */
  p_data->entry_name = KP_W (xml, "name");
  p_data->entry_organization = KP_W (xml, "organization");
  p_data->entry_comment = KP_W (xml, "comment");
  
  p_data->button_add_comp = KP_W (xml, "add");

  p_data->duration_h = KP_W (xml, "duration_h");
  p_data->duration_m = KP_W (xml, "duration_m");
  p_data->duration_s = KP_W (xml, "duration_s");
  p_data->duration_t = KP_W (xml, "duration_t");
  
  g_signal_connect (G_OBJECT (p_data->button_add_comp), "clicked",
                    G_CALLBACK (competitor_added), dialog);
  
  g_object_unref (G_OBJECT (xml));
}


static void
kp_add_competitor_dialog_finalize (GObject *object)
{
  KPAddCompetitorDialog *dialog;

  g_return_if_fail (object != NULL);
  g_return_if_fail (KP_IS_ADD_COMPETITOR_DIALOG (object));

  dialog = KP_ADD_COMPETITOR_DIALOG (object);

  g_return_if_fail (dialog->private_data != NULL);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}


/**
 * kp_add_competitor_dialog_new:
 * @date: A #KPDate
 * @log: A #KPTrainingLog
 * @wo: A #KPWorkout
 *
 * Create an instance of #KPAddCompetitorDialog.
 *
 * Returns: A #KPAddCompetitorDialog
 */
GtkWidget *
kp_add_competitor_dialog_new (KPResults *results)
{
  KPAddCompetitorDialogPrivateData *p_data;
  KPAddCompetitorDialog *dialog;
  
  g_return_val_if_fail (KP_IS_RESULTS (results), NULL);
  
  dialog = g_object_new (KP_TYPE_ADD_COMPETITOR_DIALOG, NULL);
  
  p_data = KP_ADD_COMPETITOR_DIALOG_PRIVATE_DATA (dialog);
  p_data->results = results;

  return GTK_WIDGET (dialog);
}


static guint
get_result_field (KPAddCompetitorDialog *dialog)
{
  KPAddCompetitorDialogPrivateData *p_data;
  guint h, m, s, t;
 
  g_return_val_if_fail (KP_IS_ADD_COMPETITOR_DIALOG (dialog), 0);
  
  p_data = KP_ADD_COMPETITOR_DIALOG_PRIVATE_DATA (dialog);
  
  h = (guint) gtk_spin_button_get_value (GTK_SPIN_BUTTON (p_data->duration_h));
  m = (guint) gtk_spin_button_get_value (GTK_SPIN_BUTTON (p_data->duration_m));
  s = (guint) gtk_spin_button_get_value (GTK_SPIN_BUTTON (p_data->duration_s));
  t = (guint) gtk_spin_button_get_value (GTK_SPIN_BUTTON (p_data->duration_t));

  /* Make .23 => .230; NOT .023 
   *   and .2 => .2; NOT .002 */
  if (t < 10)
    t *= 100;
  if (t >= 10 && t < 100)
    t *= 10;
  
  return (h * 60 * 60 * 1000) + (m * 60 * 1000) + (s * 1000) + t;
}


static void 
competitor_added (GtkButton *button, KPAddCompetitorDialog *dialog)
{
  KPAddCompetitorDialogPrivateData *p_data;
  KPResult *r;
  const gchar *organization;
  const gchar *comment;
  const gchar *name;
  
  p_data = KP_ADD_COMPETITOR_DIALOG_PRIVATE_DATA (dialog);
  
  organization = gtk_entry_get_text (GTK_ENTRY (p_data->entry_organization));
  comment = gtk_entry_get_text (GTK_ENTRY (p_data->entry_comment));
  name = gtk_entry_get_text (GTK_ENTRY (p_data->entry_name));
  
  if (name == NULL)
    return;
  
  r = g_new0 (KPResult, 1);
  r->result = get_result_field (dialog); 
  r->competitor = g_new0 (KPCompetitor, 1);
  r->competitor->name = g_strdup (name);
  r->competitor->organization = g_strdup ((organization) ? organization : "");
  r->comment = g_strdup ((comment) ? comment : "");

  kp_results_add_result (p_data->results, r);

  gtk_entry_set_text (GTK_ENTRY (p_data->entry_organization), "");
  gtk_entry_set_text (GTK_ENTRY (p_data->entry_comment), "");
  gtk_entry_set_text (GTK_ENTRY (p_data->entry_name), "");
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (p_data->duration_h), 0.0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (p_data->duration_m), 0.0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (p_data->duration_s), 0.0);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (p_data->duration_t), 0.0);

  gtk_widget_grab_focus (p_data->entry_name);
}



