
#ifndef _kio_beagle_H_
#define _kio_beagle_H_

#include <QString>
#include <QStringList>
#include <QPair>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

#include "beaglesearch.h"

class kio_beagleProtocol :public QObject, public KIO::SlaveBase 
{
Q_OBJECT
public:
    kio_beagleProtocol(const QByteArray &pool_socket, const QByteArray &app_socket);
    virtual	    ~kio_beagleProtocol();
    virtual void    mimetype(const KUrl& url);
    virtual void    get(const KUrl& url);
    virtual void    stat(const KUrl& url);
    virtual void    listDir(const KUrl& url);

private slots:
    void searchHasOutput(BeagleResultList &results);
    void searchFinished();
    void searchError (const QString& error);

private:
    BeagleSearch	    beagle_search;
    QHash<QString, QString> hostMap;
    QString		    bookmarkDir;

private:
    QString		     URL_ToSearchString(const KUrl &url);
    void		     showStatusPage();
    void		     createRootEntry(KIO::UDSEntry& entry);
    void		     createInformationEntry(KIO::UDSEntry& entry);
    void		     createHelpEntry(KIO::UDSEntry& entry);
    void		     createBookmarkDirEntry(KIO::UDSEntry& entry);
    void		     createAddBookmarkEntry(KIO::UDSEntry& entry);
    void		     createServiceOptionsEntry(KIO::UDSEntry& entry);
    QString		     hostToQuery(const QString host) const;
    bool		     addBookmark(const KUrl &url);
//    void addHit(const QString& uri, const QString& title, const QString& mime_type, HitType type);
};

#endif
