/***************************************************************************
 *   Copyright (C) 2006 by Valentine Sinitsyn                              *
 *   e_val@inbox.ru                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "cpufreqdprofile.h"
#include <qstringlist.h>

/**
 * This class encapsulates cpufreqd profile data: name, frequencies and governors
 *@author: Valentine Sinitsyn (Valentine.Sinitsyn@usu.ru)
 */

CPUFreqdProfile::CPUFreqdProfile(QString & descr) {
	QStringList fields = QStringList::split("/", descr);

	//@fixme: if name contains a slash, the results will be incorrect
	if (fields.count() == 5) {
		m_active = fields[0].toInt();
		m_name = fields[1];
		m_minfreq = fields[2].toInt();
		m_maxfreq = fields[3].toInt();
		m_policy = fields[4];
	}
}

CPUFreqdProfile::~ CPUFreqdProfile() {
}

bool CPUFreqdProfile::isValid() const {
	return (!m_name.isEmpty() && !m_policy.isEmpty() && m_minfreq <= m_maxfreq);
}

bool CPUFreqdProfile::active() const {
	return (m_active == 1);
}

const QString & CPUFreqdProfile::name() const {
	return m_name;
}

int CPUFreqdProfile::minfreq() const {
	return m_minfreq;
}

int CPUFreqdProfile::maxfreq() const {
	return m_maxfreq;
}

const QString & CPUFreqdProfile::policy() const {
	return m_policy;
}
