/* $Id: we_misc.c 1019 2009-02-03 19:31:11Z ekalin $ */

/*
 * Copyright (C) 2004-2009 Eduardo M Kalinowski <eduardo@kalinowski.com.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <kcconfig.h>
#endif

#include <string.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gmodule.h>

#include "simocombobox.h"

#include "kildclient.h"
#include "perlscript.h"


/***********************
 * Function prototypes *
 ***********************/


GtkWidget *
get_we_misc_tab(GladeXML *gladexml)
{
  GtkWidget *panel;

  panel    = glade_xml_get_widget(gladexml, "we_panel_misc");

  return panel;
}


void
fill_we_misc_tab(World *world, GladeXML *gladexml)
{
  GtkWidget *chkScrollOutput;
  GtkWidget *txtBufferLines;
  GtkWidget *radNameDisplayWorld;
  GtkWidget *radNameDisplayWorldChar;
  GtkWidget *radNameDisplayCharWorld;
  GtkWidget *radNameDisplayCustom;
  GtkWidget *txtNameDisplayCustom;

  if (!world) {
    return;
  }

  /* Get widgets */
  chkScrollOutput = glade_xml_get_widget(gladexml, "chkScrollOutput");
  txtBufferLines  = glade_xml_get_widget(gladexml, "txtBufferLines");
  radNameDisplayWorld
    = glade_xml_get_widget(gladexml, "radNameDisplayWorld");
  radNameDisplayWorldChar
    = glade_xml_get_widget(gladexml, "radNameDisplayWorldChar");
  radNameDisplayCharWorld
    = glade_xml_get_widget(gladexml, "radNameDisplayCharWorld");
  radNameDisplayCustom
    = glade_xml_get_widget(gladexml, "radNameDisplayCustom");
  txtNameDisplayCustom
    = glade_xml_get_widget(gladexml, "txtNameDisplayCustom");

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkScrollOutput),
                               world->scrollOutput);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(txtBufferLines),
                            world->buffer_lines);

  switch (world->name_display_style) {
  case NAME_DISPLAY_WORLD:
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radNameDisplayWorld),
                                 TRUE);
    break;

  case NAME_DISPLAY_WORLD_CHAR:
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radNameDisplayWorldChar),
                                 TRUE);
    break;

  case NAME_DISPLAY_CHAR_WORLD:
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radNameDisplayCharWorld),
                                 TRUE);
    break;

  case NAME_DISPLAY_CUSTOM:
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radNameDisplayCustom),
                                 TRUE);
    break;
  }
  gtk_entry_set_text(GTK_ENTRY(txtNameDisplayCustom),
                     world->name_display_pattern);
}



void
update_we_misc_parameters(World *world)
{
  GladeXML  *gladexml;
  GtkWidget *chkScrollOutput;
  GtkWidget *txtBufferLines;
  GtkWidget *radNameDisplayWorld;
  GtkWidget *radNameDisplayWorldChar;
  GtkWidget *radNameDisplayCharWorld;
  GtkWidget *radNameDisplayCustom;
  GtkWidget *txtNameDisplayCustom;

  const gchar *newval;

  /* Get widgets */
  gladexml        = glade_get_widget_tree(world->dlgEditWorld);
  chkScrollOutput = glade_xml_get_widget(gladexml, "chkScrollOutput");
  txtBufferLines  = glade_xml_get_widget(gladexml, "txtBufferLines");
  radNameDisplayWorld
    = glade_xml_get_widget(gladexml, "radNameDisplayWorld");
  radNameDisplayWorldChar
    = glade_xml_get_widget(gladexml, "radNameDisplayWorldChar");
  radNameDisplayCharWorld
    = glade_xml_get_widget(gladexml, "radNameDisplayCharWorld");
  radNameDisplayCustom
    = glade_xml_get_widget(gladexml, "radNameDisplayCustom");
  txtNameDisplayCustom
    = glade_xml_get_widget(gladexml, "txtNameDisplayCustom");

  world->scrollOutput =
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chkScrollOutput));

  world->buffer_lines =
    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(txtBufferLines));

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radNameDisplayWorld))) {
    world->name_display_style = NAME_DISPLAY_WORLD;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radNameDisplayWorldChar))) {
    world->name_display_style = NAME_DISPLAY_WORLD_CHAR;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radNameDisplayCharWorld))) {
    world->name_display_style = NAME_DISPLAY_CHAR_WORLD;
  } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radNameDisplayCustom))) {
    world->name_display_style = NAME_DISPLAY_CUSTOM;
  }

  newval = gtk_entry_get_text(GTK_ENTRY(txtNameDisplayCustom));
  if (!world->name_display_pattern
      || strcmp(world->name_display_pattern, newval) != 0) {
    g_free(world->name_display_pattern);
    world->name_display_pattern = g_strdup(newval);
  }
}
