/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef LISTALLPROPERTIESDEFAULTACTIONSERVICEMENUFILLER_H
#define LISTALLPROPERTIESDEFAULTACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
// kde specific
#include <kabc/addresseelist.h>
// khalkhi core
#include "listallpropertiesglobalactionserviceclient.h"
// lib specific
#include "idserviceactionmap.h"

class QPopupMenu;

namespace Khalkhi {

class KDE_EXPORT ListAllPropertiesGlobalActionServiceMenuFiller : public QObject, public ListAllPropertiesGlobalActionServiceClient
{
    Q_OBJECT
public:
    ListAllPropertiesGlobalActionServiceMenuFiller();
    virtual ~ListAllPropertiesGlobalActionServiceMenuFiller();

public:
    void setPersonList( const KABC::AddresseeList& List );
    int fillMenu( QPopupMenu *Menu, int BaseMenuId );

public: // GlobalServiceClient interface
    virtual void onGlobalActionServiceSwitch( const QString &PropertyId );
    virtual void onPropertyManagerChange();

public: // ServiceClient interface
    virtual const KABC::AddresseeList &personList() const;
    virtual void onActionServiceStateChange( const PropertyActionService &Service, int Change,
                                             int ItemIndex );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    KABC::AddresseeList PersonList;

    QPopupMenu *Menu;
    IdServiceActionMap IdActionMap;
};


inline ListAllPropertiesGlobalActionServiceMenuFiller::ListAllPropertiesGlobalActionServiceMenuFiller() : Menu( 0 ) {}

inline void ListAllPropertiesGlobalActionServiceMenuFiller::setPersonList( const KABC::AddresseeList &L )
{ PersonList = L; }

}

#endif
