/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


#ifndef ALLPROPERTIESDEFAULTDATAACTIONSERVICEMENUFILLER_H
#define ALLPROPERTIESDEFAULTDATAACTIONSERVICEMENUFILLER_H


// qt specific
#include <qobject.h>
// kde specific
#include <kabc/addressee.h>
// khalkhi core
#include "allpropertiesglobaldataactionserviceclient.h"
// lib specific
#include "idserviceactionmap.h"

class QPopupMenu;


namespace Khalkhi {


class KDE_EXPORT AllPropertiesGlobalDataActionServiceMenuFiller : public QObject, public AllPropertiesGlobalDataActionServiceClient
{
    Q_OBJECT
public:
    AllPropertiesGlobalDataActionServiceMenuFiller();
    virtual ~AllPropertiesGlobalDataActionServiceMenuFiller();

public:
    void set( const KABC::Addressee& P, QMimeSource *E );
    int fillMenu( QPopupMenu *Menu, int BaseMenuId );

public: // GlobalDropServiceClient API
    virtual void onGlobalDataActionServiceSwitch( const QString &PropertyId );
    virtual void onPropertyManagerChange();

public: // DropServiceClient API
    virtual const KABC::Addressee& person() const;
    virtual QMimeSource *dataSource() const;
    virtual void onDataActionServiceStateChange( const PropertyDataActionService &Service, int Change,
                                                 int ItemIndex );

protected slots:
    void onMenuSelection( int Id );
    void onMenuDestruction();

protected:
    KABC::Addressee Person;
    QMimeSource *DataSource;

    QPopupMenu *Menu;
    IdServiceActionMap IdActionMap;
};


inline AllPropertiesGlobalDataActionServiceMenuFiller::AllPropertiesGlobalDataActionServiceMenuFiller()
: Menu( 0 ) {}

inline void AllPropertiesGlobalDataActionServiceMenuFiller::set( const KABC::Addressee& P, QMimeSource *E ) { Person = P; DataSource = E; }

}

#endif
