/*
    This file is part of the KDE project.
    Copyright (c) 2006 Friedrich W. H. Kossebau <kossebau@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301  USA
*/


// qt specific
#include <qpopupmenu.h>
// khalkhi core
#include <services.h>
// lib specific
#include "actionservicemenufiller.h"


namespace Khalkhi {

ActionServiceMenuFiller::ActionServiceMenuFiller()
: Menu( 0 ) {}

void ActionServiceMenuFiller::setContext( const char *C )
{
    Context = QString::fromLatin1( C );
}

void ActionServiceMenuFiller::set( const KABC::Addressee& C )
{
    Person = C;
}

const KABC::Addressee& ActionServiceMenuFiller::person() const { return Person; }


void ActionServiceMenuFiller::onActionServiceStateChange( const ActionService &Service, int /*Change*/ )
{
    const QString &ServiceId = Service.id();

    // find menuid of action
    int MenuId = -1;
    int i = BaseMenuId;
    for ( QStringList::Iterator it = MenuServiceIds.begin(); it != MenuServiceIds.end(); ++it,++i )
        if( *it == ServiceId )
        {
            MenuId = i;
            break;
        }

    if( MenuId != -1 )
    {
        ServiceAction Action = Service.action( Person, 0 );

        QString Entry = Action.data( DisplayTextRole ).asString();
        QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
        bool Enabled = Action.data( EnabledRole ).asBool();

        Menu->changeItem( MenuId, IconSet, Entry );
        Menu->setItemEnabled( MenuId, Enabled );
    }
}

int ActionServiceMenuFiller::fillMenu( QPopupMenu *M, int BMI )
{
    BaseMenuId = BMI;
    Menu = M;
    MenuServiceIds.clear();

    connect( Menu, SIGNAL(destroyed()), SLOT(onMenuDestruction()) );
    Services::self()->registerClient( this );

    const ServiceManager *Manager = &Services::self()->serviceManager();

    const ActionServiceList &Services = Manager->actionServices();

    int MenuId = BaseMenuId;
    for( ActionServiceList::ConstIterator ServiceIt = Services.begin(); ServiceIt != Services.end(); ++ServiceIt )
    {
        const ActionService *Service = *ServiceIt;

        if( !Service->isAvailable() )
            ;// TODO: 
        else if( Service->supports(Person) && Service->fitsIn(Context) )
        {
            ServiceAction Action = Service->action( Person, 0 );

            QString Entry = Action.data( DisplayTextRole ).asString();
            QIconSet IconSet = Action.data( DisplayIconRole ).asIconSet();
            bool Enabled = Action.data( EnabledRole ).asBool();

            Menu->insertItem( IconSet, Entry, this, SLOT(onMenuSelection(int)), 0, MenuId );
            if( !Enabled )
                Menu->setItemEnabled( MenuId, false );
            MenuServiceIds.append( Service->id() );
            ++MenuId;
        }
    }

    return MenuId - BaseMenuId;
}

void ActionServiceMenuFiller::onMenuSelection( int MenuId )
{
   Services::self()->execute( Person, MenuServiceIds[MenuId-BaseMenuId] );
}

void ActionServiceMenuFiller::onMenuDestruction()
{
    Menu = 0;
    Services::self()->unregisterClient( this );
}

ActionServiceMenuFiller::~ActionServiceMenuFiller() {}

}

#include "actionservicemenufiller.moc"
