/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004 by Michael Buesch                                  *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   KWallet DCOP Interface is                                             *
 *    Copyright (c) 2002-2003 George Staikos <staikos@kde.org>             *
 *   KWallet is part of the KDE libraries                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef __KDED_KWALLETEMU_H
#define __KDED_KWALLETEMU_H

#include <kdedmodule.h>
#include <dcopclient.h>
#include <qcstring.h>
#include <qstringlist.h>

/* enable/disable Kded_KwalletEmu debugging */
#define KDED_KWALLETEMU_DEBUG	0

class KWalletEmu_stub;

/** This is the KDED kwalletd emulation layer module
  * for PwManager.
  * This module maps all KWallet DCOP calls on
  * the PwManager KWallet emulation interface.
  */
class Kded_KWalletEmu : public KDEDModule
{
	Q_OBJECT
	K_DCOP
public:
	Kded_KWalletEmu(const QCString &name);
	~Kded_KWalletEmu();

protected:
	/** stub object of _real_ emulation interface */
	KWalletEmu_stub *stub;
	/** DCOP client object */
	DCOPClient *dcopClient;

protected:
	QCString DCOPPeerName() const;

k_dcop:
/* KWallet interface emulation */
	bool isEnabled() const;
	int open(const QString& wallet, uint wId);
	int openPath(const QString& path, uint wId);
	void openAsynchronous(const QString& wallet,
			      const QCString& returnObject,
			      uint wId);
	int close(const QString& wallet, bool force);
	int close(int handle, bool force);
	ASYNC sync(int handle);
	int deleteWallet(const QString& wallet);
	bool isOpen(const QString& wallet) const;
	bool isOpen(int handle);
	QStringList users(const QString& wallet) const;
	void changePassword(const QString& wallet, uint wId);
	QStringList wallets() const;
	QStringList folderList(int handle);
	bool hasFolder(int handle, const QString& folder);
	bool createFolder(int handle, const QString& folder);
	bool removeFolder(int handle, const QString& folder);
	QStringList entryList(int handle,
			      const QString& folder);
	QByteArray readEntry(int handle,
			     const QString& folder,
			     const QString& key);
	QByteArray readMap(int handle,
			   const QString& folder,
			   const QString& key);
	QString readPassword(int handle,
			     const QString& folder,
			     const QString& key);
	int renameEntry(int handle,
			const QString& folder,
			const QString& oldName,
			const QString& newName);
	int writeEntry(int handle,
		       const QString& folder,
		       const QString& key,
		       const QByteArray& value,
		       int entryType);
	int writeEntry(int handle,
		       const QString& folder,
		       const QString& key,
		       const QByteArray& value);
	int writeMap(int handle,
		     const QString& folder,
		     const QString& key,
		     const QByteArray& value);
	int writePassword(int handle,
			  const QString& folder,
			  const QString& key,
			  const QString& value);
	bool hasEntry(int handle,
		      const QString& folder,
		      const QString& key);
	int entryType(int handle,
		      const QString& folder,
		      const QString& key);
	int removeEntry(int handle,
			const QString& folder,
			const QString& key);
	bool disconnectApplication(const QString& wallet,
				   const QCString& application);
	void reconfigure();
	bool folderDoesNotExist(const QString& wallet,
				const QString& folder);
	bool keyDoesNotExist(const QString& wallet,
			     const QString& folder,
			     const QString& key);
	void closeAllWallets();

/* additional DCOP functions */
	bool isEmulated() const;
	QString emulationApp() const;


/* functions for signal forwarding
 * These functions are INTERNAL. They will only accept
 * calls from (DCOPPeerName() == PWMANAGER_DCOP_APP)
 *
 * DO NOT call these functions.
 */
	ASYNC sig_walletClosed(const QString &wallet);
	ASYNC sig_walletClosed(int handle);
	ASYNC sig_allWalletsClosed();
	ASYNC sig_applicationDisconnected(const QString &wallet,
					  const QCString &application);
	ASYNC sig_folderUpdated(const QString &wallet,
				const QString &folder);
	ASYNC sig_folderListUpdated(const QString &wallet);
	ASYNC sig_walletListDirty();
	ASYNC sig_walletCreated(const QString &wallet);
	ASYNC sig_walletOpened(const QString &wallet);
	ASYNC sig_walletDeleted(const QString &wallet);
};

#endif
