/***************************************************************************
 *                                                                         *
 *   copyright (C) 2004, 2005  by Michael Buesch                           *
 *   email: mbuesch@freenet.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 ***************************************************************************/

#ifndef GENPASSWD_EXTERN_H_
#define GENPASSWD_EXTERN_H_

#include <qstring.h>

#include <kprocess.h>


/** password generator that uses an external generator */
class GenPasswd_extern : public QObject
{
	Q_OBJECT

public:
	GenPasswd_extern();
	~GenPasswd_extern();

	/** start to generate a new password and return it.
	  * Returns an empty string on error.
	  */
	QString gen();
	/** set the shell command. */
	void setCmd(const QString &_cmd)
			{ cmd = _cmd; }
	/** Get the last error message. */
	QString getError() const
			{ return error; }

protected slots:
	void receivedStdout(KProcess *_proc, char *buffer, int buflen);
	void receivedStderr(KProcess *_proc, char *buffer, int buflen);
	void cleanOutput();

protected:
	/** the shell command to execute. */
	QString cmd;
	/** KProcess object to execute the shell command. */
	KProcess proc;
	/** received stdout. */
	QString recStdout;
	/** received stderr. */
	QString recStderr;
	/** Error message. */
	QString error;
};

#endif // GENPASSWD_EXTERN_H_
