/***************************************************************************
                          logwindow.cpp  -  description
                             -------------------
    begin                : Wed Feb 14 2001
    copyright            : (C) 2001 by Javier Campos Morales
    email                : javi_cms@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "logwindow.h"
#include <logwindow.moc>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>

LogWindow::LogWindow(QWidget *parent, const char *name ) : KDialogBase(Swallow, i18n("Log window"), Close, Close, parent, name, false, true)
{
	KConfig *config = KGlobal::config();

	config->setGroup("Log Window");
	QSize *defaultSize = new QSize(500,350);
	this->resize( config->readSizeEntry("Geometry", defaultSize ) );

	logView = new QTextView(this, "logview");
	setMainWidget(logView);

}

LogWindow::~LogWindow()
{
}

/** Set text */
void LogWindow::setText( const QString &text )
{
	logView->setText( text );
}

/** Close window */
void LogWindow::slotClose()
{
  KConfig *config = KGlobal::config();

	config->setGroup("Log Window");
	config->writeEntry("Geometry", this->size() );
  config->sync();

	this->accept();
}
