/****************************************************************************
** Form implementation generated from reading ui file 'ExtractDlg.ui'
**
** Created: Tue Oct 19 11:49:05 2004
**      by: The User Interface Compiler ()
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "extractdlg.h"
#include "extractdlg.moc"

#include <klocale.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <kurlrequester.h>
#include <kmessagebox.h>

#include <qdialog.h>
#include <qvariant.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qdir.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/*
 *  Constructs a ExtractDlg as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
/**
 * 
 * @param parent 
 * @param name 
 * @return 
 */
ExtractDlg::ExtractDlg( QWidget* parent, const char* name, bool modal, WFlags fl ) : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( i18n("Extract options") );
	setSizeGripEnabled( TRUE );
	MyDialogLayout = new QGridLayout( this, 1, 1, 11, 6, "MyDialogLayout"); 
	
	layout6 = new QGridLayout( 0, 1, 1, 0, 6, "layout6"); 
	
	textLabel3 = new QLabel( this, "textLabel3" );
	
	layout6->addWidget( textLabel3, 0, 0 );
	
	textLabel4 = new QLabel( this, "textLabel4" );
	
	layout6->addWidget( textLabel4, 1, 0 );
	
	DirName_label = new QLabel( this, "DirName_label" );
	
	layout6->addWidget( DirName_label, 1, 1 );
	
	FileName_label = new QLabel( this, "FileName_label" );
	
	layout6->addWidget( FileName_label, 0, 1 );
	
	MyDialogLayout->addLayout( layout6, 0, 0 );
	spacer29 = new QSpacerItem( 100, 41, QSizePolicy::Expanding, QSizePolicy::Minimum );
	MyDialogLayout->addItem( spacer29, 0, 1 );
	
	buttonGroup1 = new QButtonGroup( this, "buttonGroup1" );
	
	kurlrequest = new KURLRequester( buttonGroup1, "kurlrequest" );
	kurlrequest->setGeometry( QRect( 50, 70, 270, 32 ) );
	
	extractDir_radio = new QRadioButton( buttonGroup1, "extractDir_radio" );
	extractDir_radio->setGeometry( QRect( 20, 40, 270, 22 ) );
	
	extractCurrent_radio = new QRadioButton( buttonGroup1, "extractCurrent_radio" );
	extractCurrent_radio->setGeometry( QRect( 20, 20, 270, 22 ) );
	extractCurrent_radio->setChecked(true);
	slotExtractCheck();
	
	MyDialogLayout->addMultiCellWidget( buttonGroup1, 2, 2, 0, 1 );
	
	layout5 = new QGridLayout( 0, 1, 1, 0, 6, "layout5"); 
	
	buttonCancel = new QPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	
	layout5->addWidget( buttonCancel, 0, 2 );
	
	buttonOk = new QPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	
	layout5->addWidget( buttonOk, 0, 1 );
	Horizontal_Spacing2 = new QSpacerItem( 230, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
	layout5->addItem( Horizontal_Spacing2, 0, 0 );
	
	MyDialogLayout->addMultiCellLayout( layout5, 3, 3, 0, 1 );
	
	view_extractfiles = new QTextEdit( this, "view_extractfiles" );
	
	MyDialogLayout->addMultiCellWidget( view_extractfiles, 1, 1, 0, 1 );
	languageChange();
	resize( QSize(386, 439).expandedTo(minimumSizeHint()) );
	clearWState( WState_Polished );
	
	// signals and slots connections
	connect( buttonOk, SIGNAL( clicked() ), this, SLOT( slotOK() ) );
	connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( extractCurrent_radio, SIGNAL( clicked() ), this, SLOT( slotExtractCheck() ) );
	connect( extractDir_radio, SIGNAL( clicked() ), this, SLOT( slotExtractCheck() ) );
	
}

/*
 *  Destroys the object and frees any allocated resources
 */
ExtractDlg::~ExtractDlg()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void ExtractDlg::languageChange()
{
    setCaption( i18n( "Extract options" ) );
    FileName_label->setText( i18n( "file name" ) );
    DirName_label->setText( i18n( "directory" ) );
    textLabel3->setText( i18n( "Name :" ) );
    textLabel4->setText( i18n( "Directory :" ) );
    buttonOk->setText( i18n( "&OK" ) );
    buttonOk->setAccel( QKeySequence( QString::null ) );
    buttonCancel->setText( i18n( "&Cancel" ) );
    buttonCancel->setAccel( QKeySequence( QString::null ) );
    buttonGroup1->setTitle( i18n( "Actions" ) );
    extractDir_radio->setText( i18n( "Extract files in ..." ) );
    extractCurrent_radio->setText( i18n( "Extract files in current Directory." ) );
}

void ExtractDlg::slotExtractCheck()
{
	if( extractDir_radio->isChecked() )
	{		if( !kurlrequest->isEnabled() ) kurlrequest->setEnabled(true);		}
	else
	{		if( kurlrequest->isEnabled() ) kurlrequest->setEnabled(false);		}
}

void ExtractDlg::slotOutputMessages(KProcess*,char *buffer,int buflen)
{
	for( int i = 0; i < buflen; i++ )
	{
	if( *buffer == '\n' )
		{
		view_extractfiles->insertParagraph( streamLine, -1 );
// 		view_extractfiles->insertLine( streamLine );
//		view_extractfiles->setCursorPosition(view_extractfiles->numLines(),0);
		streamLine = "";
	} else {
		streamLine += *buffer;
	}
	++buffer;
	}
}

void ExtractDlg::slotFinishAction()
{
	KMessageBox::information(this, i18n("The extract process has finished"), i18n("Information"), QString::null, false);
}

void ExtractDlg::slotOK()
{
	KConfig *config = KGlobal::config();

	config->setGroup("Extract options");
	config->writeEntry("Geometry", this->size() );
	config->sync();

	QApplication::disconnect( &q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	QApplication::disconnect( &q, SIGNAL(receivedStderr(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	QApplication::connect( &q, SIGNAL(processExited(KProcess *)),this, SLOT(slotFinishAction()) );
	if( extractCurrent_radio->isChecked() )
	{
		execute( "tar " + extractCompress + "xvf " + DirName_label->text() + FileName_label->text() + " -C " + DirName_label->text() );
	}
	else
	{
		execute( "tar zxvf " + DirName_label->text() + FileName_label->text() + " -C " + kurlrequest->url() );
	}

	this->accept();
}

void ExtractDlg::execute(const char *file)
{
	QString Comm_Args;
	QString SFile = file;
	int buflen = SFile.length();
	
	q.clearArguments();
//	QDir::setCurrent( DirName_label->text() );
	streamLine = "";
//	view_extractfiles->clear();
//	view_main->setWordWrap( QMultiLineEdit::NoWrap );
	for( int i = 0; i < buflen; i++ )
	{
	if( *file == ' ' )
		{
		q << Comm_Args;
		Comm_Args = "";
		} else {
		Comm_Args += *file;
		}
	++file;
	}
	q << Comm_Args;

	q.start( KProcess::Block, KProcess::AllOutput );
}

void ExtractDlg::setFile(const KURL &url, const QString &comp)
{
	FileName_label->setText( url.fileName() );
	DirName_label->setText( url.directory(false,true) );
	extractCompress = comp;

	QApplication::connect( &q, SIGNAL(receivedStdout(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	QApplication::connect( &q, SIGNAL(receivedStderr(KProcess *, char *, int)),this,SLOT(slotOutputMessages(KProcess *, char *, int)));
	execute( "tar -t" + extractCompress + "f " + DirName_label->text() + FileName_label->text() );
}

KURL ExtractDlg::getFile()
{
	KURL url;

	if( extractCurrent_radio->isChecked() )
		url.setPath( DirName_label->text() + view_extractfiles->text(0) );
		else
		url.setPath( kurlrequest->url() + view_extractfiles->text(0) );

	url.setFileName("configure");
	return url;
}

QString ExtractDlg::extractDir()
{
	return kurlrequest->url();
}

bool ExtractDlg::isCurrentDir()
{
	return extractCurrent_radio->isChecked();
}

