/***************************************************************************
                         kscriptedit.cpp  -  script edit dialog
                         -------------------
    begin                : Thu Aug 28 2003
    copyright            : (C) 2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qradiobutton.h>

#include <klocale.h>
#include <klineedit.h>
#include <kurlrequester.h>
#include <kactivelabel.h>
#include <kmessagebox.h>

#include "kscriptedit.h"

#include <kdebug.h>

KScriptEdit::KScriptEdit(QWidget *parent, char *name, bool modal)
  : KDialogBase(Plain, i18n("Script Editor"), Help|Ok|Cancel,
                Ok, parent, name, modal, true)
{
  // TODO: write and set the proper link to documentation
  setHelp("kcmpureftpdscript/index.html", QString::null);

  scriptEdit = new ScriptEdit(plainPage());
  QVBoxLayout *vlayout = new QVBoxLayout(plainPage(), 0, spacingHint());
  vlayout->addWidget(scriptEdit);

  connect(scriptEdit, SIGNAL(configChanged()), this, SLOT(slotChanged()));
  enableButton(Ok, false);
  configChanged=false;
}

void KScriptEdit::setData(ScriptPref p)
{
  id=p.id;
  templateid=p.templateid;
  outputfilemode=p.outputfilemode;
  runmode=p.runmode;
  scriptEdit->title->setText(p.title);
  scriptEdit->description->setText(p.description);
  scriptEdit->outputFile->setURL(p.outputfile);
  enableButton(Ok, false);
  configChanged=false;
}

void KScriptEdit::setInfo(const QString &s)
{
  scriptEdit->infoLabel->setText(s);
}

void KScriptEdit::slotChanged()
{
  enableButton(Ok, true);
  configChanged=true;
}

void KScriptEdit::slotOk()
{
  if (getData()) {
    accept();
  }
}

void KScriptEdit::slotApply()
{
  getData();
}

bool KScriptEdit::getData()
{
  QString title = scriptEdit->title->text();
  QString description = scriptEdit->description->text();
  QString outputfile = scriptEdit->outputFile->url();

  title=title.stripWhiteSpace();
  description=description.stripWhiteSpace();
  outputfile=outputfile.stripWhiteSpace();
  scriptEdit->title->setText(title);
  scriptEdit->description->setText(description);
  scriptEdit->outputFile->setURL(outputfile);

  if (title.isEmpty()) {
    KMessageBox::sorry(this,i18n("You must enter a name for the script."),i18n("Empty Script Name"));
    return false;
  } else if (title.length() > MAXTITLE) {
    KMessageBox::sorry(this,i18n("Script name length cannot exced %1 characters.").arg(MAXTITLE),i18n("Name Too Long"));
    return false;
  } else if (description.length() > MAXDESCRIPTION) {
    KMessageBox::sorry(this,i18n("Description length cannot exced %1 characters.").arg(MAXDESCRIPTION),i18n("Description too long"));
    return false;
  } else {
    ScriptPref tmpPref;

    tmpPref.id=id;
    tmpPref.title=title;
    tmpPref.description=description;
    tmpPref.outputfile=outputfile;
    tmpPref.outputfilemode=outputfilemode;

    emit setPref(tmpPref);
    enableButton(Ok, false);
    configChanged=false;
  }

  return true;
}
