/***************************************************************************
                   pureftpd.pov  -  render KcmPureFTPd logos and icons
                             -------------------
    begin                : Thu Jul 19 2001
    copyright            : (C) 2001-2003 by Claudiu Costin
    email                : claudiuc@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


global_settings { assumed_gamma 2.2 }

#include "colors.inc"
#include "textures.inc"

//  * Pureftpd Logo  - 1
//  * Pureftpd Icon  - 2
//  * Single Pearl   - 3

#declare rendertype = 3;

#if (rendertype = 1) 
    #declare enabletext = 1;
    #declare logotext   = "PureFTPd"
    #declare cameraz    = -11;
    #declare camerax    = 3;
#end
#if (rendertype = 2) 
    #declare enabletext = 1;
    #declare logotext = "FTP"
    #declare cameraz    = -10;
    #declare camerax    = 0;
#end
#if (rendertype = 3) 
    #declare enabletext = 0;
    #declare logotext = ""
    #declare cameraz    = -10;
    #declare camerax    = 0;
#end


camera {
    location <0.0, 0.0, cameraz>
    //right x*1.3333
    //angle 70
    look_at <camerax, 0.0, 0.0>
}
                 
light_source { <60, 50, -25> rgb 1 }

//light_source { <-10, -100, -100> rgb <1, 1, 1> }

plane { z, 100  pigment { White  }
    finish { ambient .8 }
 }

#if (enabletext=1)
#declare Font="cyrvetic.ttf"
text{ ttf Font
    logotext, 0.1,0
    scale <2, 2, 4>
    translate <-2, -0.8, -4.0>
    texture {
        pigment { rgbf <1, 0.5, 0.2, 0.7> }
        finish { 
            reflection 0.4 
            diffuse 0.5
            phong 0.2
            phong_size 1
            specular 0.2
        }
    }
    interior {
        ior 1.5
    }
}
#end

sphere { <0, 0, 0>, 3
    texture {
        pigment { rgbf <0.8, 0.9, 1.0, 0.7> }
        finish { 
            reflection 0.01
            diffuse 0.1
            phong 0.2
            phong_size 1
            specular 0.2
        }
    }
    interior {
        ior 1.5
    }
}
