/***************************************************************************
 *   Copyright (C) 2004-2009 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qapplication.h>
#include <qspinbox.h>

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <settings.h>
#include <fileimporterbibtex.h>
#include "webqueryzmath.h"

namespace KBibTeX
{
    WebQueryZMATHWidget::WebQueryZMATHWidget( QWidget *parent, const char *name )
            : WebQueryWidget( parent, name )
    {
        init();

        Settings *settings = Settings::self();
        QString value = settings->getWebQueryDefault( "ZMATH" );
        value = value == QString::null ? "" : value;
        lineEditQuery->setText( value );
        slotTextChanged( value, true );
    }

    WebQueryZMATH::WebQueryZMATH( QWidget* parent ): WebQuery( parent )
    {
        m_widget = new WebQueryZMATHWidget( parent );
    }

    WebQueryZMATH::~WebQueryZMATH()
    {
        delete m_widget;
    }

    QString WebQueryZMATH::title()
    {
        return i18n( "Zentralblatt MATH" );
    }

    QString WebQueryZMATH::disclaimer()
    {
        return i18n( "About Zentralblatt MATH" );
    }

    QString WebQueryZMATH::disclaimerURL()
    {
        return "http://www.zentralblatt-math.org/zmath/en/";
    }

    WebQueryWidget *WebQueryZMATH::widget()
    {
        return m_widget;
    }

    void WebQueryZMATH::query()
    {
        WebQuery::query();
        Settings *settings = Settings::self();
        settings->setWebQueryDefault( "ZMATH", m_widget->lineEditQuery->text() );

        int numberOfResults = m_widget->spinBoxMaxHits->value();
        setNumStages( 1 );

        QString searchTerm = m_widget->lineEditQuery->text().stripWhiteSpace().replace( '$', "" );
        if ( searchTerm.isEmpty() )
        {
            setEndSearch( WebQuery::statusInvalidQuery );
            return;
        }

        KURL url = KURL( QString( "http://www.zentralblatt-math.org/zmath/en/search/?q=%2&count=%1&type=bibtex&format=short&display=all" ).arg( numberOfResults ).arg( searchTerm.replace( "%", "%25" ).replace( "+", "%2B" ).replace( " ", "%20" ).replace( "#", "%23" ).replace( "&", "%26" ).replace( "?", "%3F" ) ) );
        BibTeX::File *bibtexFile = downloadBibTeXFile( url );
        if ( bibtexFile != NULL && !m_aborted )
        {
            for ( BibTeX::File::ElementList::iterator it = bibtexFile->begin(); it != bibtexFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    emit foundEntry( new BibTeX::Entry( entry ), false );
            }

            setEndSearch( WebQuery::statusSuccess );
        }
        else if ( !m_aborted )
        {
            QString message = KIO::NetAccess::lastErrorString();
            if ( message.isEmpty() )
                message.prepend( '\n' );
            message.prepend( QString( i18n( "Querying database '%1' failed." ) ).arg( title() ) );
            KMessageBox::error( m_parent, message );
            setEndSearch( WebQuery::statusError );
        }
        else
            setEndSearch( WebQuery::statusAborted );

        if ( bibtexFile != NULL ) delete bibtexFile;
    }

}
