//
// C++ Interface: paragraphfieldwidget
//
// Description: 
//
//
// Author: Thach Nguyen <thach.nguyen@rmit.edu.au>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef GUIPARAGRAPHFIELDWIDGET_H
#define GUIPARAGRAPHFIELDWIDGET_H

#include <fieldwidget.h>
#include <qtextedit.h>
#include <qcheckbox.h>
#include "fieldtextedit.h"

class KPushButton;
class KPopupMenu;

namespace GUI {

/**
	@author Thach Nguyen <thach.nguyen@rmit.edu.au>
*/
class ParagraphFieldWidget : public FieldWidget
{
Q_OBJECT
public:
    public:
    ParagraphFieldWidget(QString _name, RefField* field,  QStringList macros, QWidget *parent = 0, const char *name = 0);

    ~ParagraphFieldWidget();
	virtual void setText(QString );
	virtual void setMacro(bool macro) {m_stringMacroIndicator->setChecked(macro); }
	virtual QString getText();
	virtual bool getMacro(void) { return m_stringMacroIndicator->isChecked(); }
	virtual void setAutoCompletion(QStringList);

private slots:
	void slotMacroMenuActivated(int);	
	
private:
	GUI::FieldTextEdit *m_textEdit;
	QCheckBox *m_stringMacroIndicator;
	KPushButton *m_stringMacroSelect;	
	KPopupMenu *m_stringMacroMenu;

	
};

}

#endif
