#include "image_glue.h"
#include <gdfonts.h>
#include <gdfontl.h>
#include <gdfontmb.h>
#include <gdfontg.h>
#include <gdfontt.h>
#include "binary_glue.h"
#include <cstring>

void* createImage(int x,int y, int tc)
{
  if (tc) {
      return (void*)(gdImageCreateTrueColor(x, y));
  } else {
      return (void*)(gdImageCreate(x, y));
  }
}

void destroyImage(void* img)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImageDestroy(p);
}

/// Returns an Image directly
KayaValue createImageFromPNG(void* f)
{
    gdImagePtr p = gdImageCreateFromPng((FILE*)f);
    int x = p->sx;
    int y = p->sy;
    KayaValue img = KayaUnion(0,3);
    KayaUnionSetArg(img,0,KayaInt((kint)p));
    KayaUnionSetArg(img,1,KayaInt(x));
    KayaUnionSetArg(img,2,KayaInt(y));
    return img;
}

/// Returns an Image directly
KayaValue createImageFromJPEG(void* f)
{
    gdImagePtr p = gdImageCreateFromJpeg((FILE*)f);
    int x = p->sx;
    int y = p->sy;
    KayaValue img = KayaUnion(0,3);
    KayaUnionSetArg(img,0,KayaInt((kint)p));
    KayaUnionSetArg(img,1,KayaInt(x));
    KayaUnionSetArg(img,2,KayaInt(y));
    return img;
}

int imageColourAllocate(void* img, int r, int g, int b, int a)
{
    gdImagePtr p = (gdImagePtr)img;
    return gdImageColorAllocateAlpha(p,r,g,b,a);
}

void imageLine(void* img, int x1, int y1, int x2, int y2, int col)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImageLine(p, x1,y1,x2,y2, col);
}

void imageDashedLine(void* img, int x1, int y1, int x2, int y2, int col)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImageDashedLine(p, x1,y1,x2,y2, col);
}

void imageSetPixel(void* img, int x, int y, int col)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImageSetPixel(p, x,y, col);
}

void imageDrawPoly(void* img, KayaArray pts, int col, int filled)
{
    gdImagePtr p = (gdImagePtr)img;
    int size = KayaArraySize(pts);

    gdPoint* points = new gdPoint[size];
    for(int i=0;i<size;i++) {
	KayaValue pair = KayaArrayLookup(pts,i);
	int x = KayaGetInt(KayaUnionGetArg(pair,0));
	int y = KayaGetInt(KayaUnionGetArg(pair,1));
	points[i].x = x;
	points[i].y = y;
    }
    if (filled) {
	gdImageFilledPolygon(p,points,size,col);
    } else {
	gdImagePolygon(p,points,size,col);
    }

    delete points;
}

void imageRectangle(void* img, int x1, int y1, int x2, int y2, 
		    int col, int filled)
{
    gdImagePtr p = (gdImagePtr)img;
    if (filled) {
	gdImageFilledRectangle(p, x1,y1,x2,y2, col);
    } 
    else {
	gdImageRectangle(p, x1,y1,x2,y2, col);
    }
}

void imageArc(void* img, int cx, int cy, int w, int h, int s, int e,
	      int col, KayaArray st, int filled)
{
    int style=0;
    for(int i=0;i<KayaArraySize(st);i++) {
	int tag = KayaUnionGetTag(KayaArrayLookup(st,i));
	switch(tag) {
	case 0:
	    style = style | gdArc;
	    break;
	case 1:
	    style = style | gdChord;
	    break;
	case 2:
	    style = style | gdPie;
	    break;
	case 3:
	    style = style | gdNoFill;
	    break;
	case 4:
	    style = style | gdEdged;
	    break;
	default: // Do nothing
	    break;
	}
    }

    gdImagePtr p = (gdImagePtr)img;
    if (filled) {
	gdImageFilledArc(p, cx,cy,w,h,s,e,col,style);
    }
    else {
	gdImageArc(p, cx,cy,w,h,s,e,col);
    }
}

void imageCopy(void* dest,void* src, int dstx, int dsty, int srcx,
	       int srcy, int w, int h)
{
    gdImagePtr srcp = (gdImagePtr)src;
    gdImagePtr destp = (gdImagePtr)dest;

    gdImageCopy(destp,srcp,dstx,dsty,srcx,srcy,w,h);
}

void imageCopyResized(void* dest,void* src, int dstx, int dsty, int srcx,
		      int srcy, int destw, int desth, int srcw, int srch)
{
    gdImagePtr srcp = (gdImagePtr)src;
    gdImagePtr destp = (gdImagePtr)dest;

    gdImageCopyResized(destp,srcp,dstx,dsty,srcx,srcy,destw,desth,srcw,srch);
}


void imageWritePNG(void* img, void* out)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImagePng(p, (FILE*)out);
}

KayaValue imageGetPNG(void* img)
{
  gdImagePtr p = (gdImagePtr)img;
  int* size = (int*)GC_MALLOC(sizeof(int));
  void* jpeg = gdImagePngPtr(p,size);
  void* bindata = newBlock(size[0]);
  memcpy(bindata,jpeg,size[0]);
  gdFree(jpeg); // now we have a GCable void*
  return imageGetBinary(bindata,size[0]);
}

void imageWriteJPEG(void* img, void* out, int quality)
{
    gdImagePtr p = (gdImagePtr)img;
    gdImageJpeg(p, (FILE*)out, quality);
}

KayaValue imageGetJPEG(void* img, int quality) 
{
  gdImagePtr p = (gdImagePtr)img;
  int* size = (int*)GC_MALLOC(sizeof(int));
  void* jpeg = gdImageJpegPtr(p,size,quality);
  void* bindata = newBlock(size[0]);
  memcpy(bindata,jpeg,size[0]);
  gdFree(jpeg); // now we have a GCable void*
  return imageGetBinary(bindata,size[0]);
}

KayaValue imageGetBinary(void* bindata, int binsize) {
  /*
  Union* bin = new Union(NULL,0,2,false);
  // this should use the API
  bin->args[0] = new Value(bindata,KVT_INT);
  bin->args[1] = MKINT(binsize);
  return new Value((void*)bin,KVT_UNION);
  */
  KayaValue bin = KayaUnion(0,2);
  KayaUnionSetArg(bin,0,KayaInt((kint)bindata));
  KayaUnionSetArg(bin,1,KayaInt(binsize));
  return bin;
}

void* fontGetSmall()
{
    return (void*)(gdFontSmall);
}

void* fontGetLarge()
{
    return (void*)(gdFontLarge);
}

void* fontGetMediumBold()
{
    return (void*)(gdFontMediumBold);
}

void* fontGetGiant()
{
    return (void*)(gdFontGiant);
}

void* fontGetTiny()
{
    return (void*)(gdFontTiny);
}

void imageString(void* img, void* font, int x, int y, wchar_t* rawstr, 
		 int col, int up)
{
  char* str = wctostr(rawstr);
    gdImagePtr p = (gdImagePtr)img;
    gdFontPtr f = (gdFontPtr)font;
    if (up) {
	gdImageStringUp(p,f,x,y,(unsigned char*)str,col);
    }
    else {
	gdImageString(p,f,x,y,(unsigned char*)str,col);
    }
}


