/*
    snesrommetadata.h - Extract metadata(information) from SNES ROM file.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#ifndef SNESROMMETADATA_H
#define SNESROMMETADATA_H

#include <defaultrommetadata.h>

/**
 * Extract metadata(information) from SNES ROM file.
 * 
 * @author Michaël Larouche <michael.larouche@kdemail.net>
*/
class SnesRomMetaData : public Kamefu::DefaultRomMetaData
{
public:
	SnesRomMetaData();
	~SnesRomMetaData();
	
	virtual Kamefu::RomMetaInformation extractMetaInformation(KFileItem* item);
	virtual Kamefu::RomMetaInformation extractMetaInformation(QIODevice* device);

private:
	/**
	 * Retrieve maker(editor) code stored in HEX ASCII.
	 * This is only called when makerCoder == 0x33.
	 *
	 * @param file Reference to a QFile, needed for file access.
	 * @param stream Reference to a QDataStream, needed for file access.
	 *
	 * @return the readed maker(editor) code.
	 */
	int getMakerCode(QIODevice *file, QDataStream &stream);
	/**
	 * Guess the best header location based on 4 hardcoded
	 * location.
	 *
	 * Needed because SNES ROM file can be HiROM or LoROM and
	 * can be with a 512byte header or not.
	 *
	 * @param file Reference to a QFile, needed for file access.
	 * @param stream Reference to a QDataStream, needed for file access.
	 *
	 * @return the best location.
	 */
	int getBestHeaderLocation(QIODevice *file, QDataStream &stream);
	/**
	 * Helper function that check the validity of information based on given
	 * location. More the score is higher, more the information is valid.
	 * @return the score.
	 */
	int checkInformationValidity(int location, QIODevice *file, QDataStream &stream);
	/**
	 * Helper function to check if the SNES Internal name is inside
	 * the printable ASCII range.
	 */
	bool canPrint(const QByteArray &charArray);
};

#endif
