/*
    system.cpp - Base class for system plugin.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "system.h"

// Qt includes
#include <qstringlist.h>

// KDE include
#include <kplugininfo.h>


namespace Kamefu 
{

class System::Private
{
public:
	QStringList systemMimeTypes;
	KPluginInfo *info;
};

System::System(QObject *parent, const char *name)
 : QObject(parent, name), d(new Private())
{
}


System::~System()
{
	delete d;
}

QStringList System::getRegistredSystemMimeTypes() const
{
	return d->systemMimeTypes;
}

void System::registerSystemMimeType(const QString &mimeType)
{
	d->systemMimeTypes.append(mimeType);
}

void System::setPluginInfo(KPluginInfo *info)
{
	d->info = info;
}

QString System::displayName() const
{
	QString displayName = d->info->property( QString::fromUtf8("X-Kamefu-System-DisplayName") ).toString();

	return displayName;
}

}

#include "system.moc"
