/*
    rommetainformation.cpp - Data class used to exchange ROM Meta Information.

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "rommetainformation.h"
#include <kdebug.h>
namespace Kamefu 
{

class RomMetaInformation::Private : public KShared
{
public:
	QString url;
	QString romName;
	QString system;
	QString editor;
	QString md5Hash;
	QString country;
	QString year;
	QString genre;
	QString titlescreenPath;
	QString screenshotPath;
};

RomMetaInformation::RomMetaInformation()
	: d(new Private())
{}

RomMetaInformation::~RomMetaInformation()
{
}

RomMetaInformation::RomMetaInformation(const RomMetaInformation &copy)
 : d(copy.d)
{
// 	kdDebug() << k_funcinfo << "Implicit shared copy" << endl;
}

RomMetaInformation &RomMetaInformation::operator=(const RomMetaInformation &other)
{
// 	kdDebug() << k_funcinfo << "Implicit shared assignment" << endl;

	d = other.d;
	return *this;
}

bool RomMetaInformation::isValid() const
{
	return !md5Hash().isEmpty() || !url().isEmpty() || !editor().isEmpty();
}

QString RomMetaInformation::url() const
{
	return d->url;
}

void RomMetaInformation::setUrl(const QString &url)
{
	d->url = url;
}

QString RomMetaInformation::romName() const
{
	return d->romName;
}

void RomMetaInformation::setRomName(const QString &romName)
{
	d->romName = romName;
}

QString RomMetaInformation::system() const
{
	return d->system;
}

void RomMetaInformation::setSystem(const QString &system)
{
	d->system = system;
}

QString RomMetaInformation::editor() const
{
	return d->editor;
}

void RomMetaInformation::setEditor(const QString &editor)
{
	d->editor = editor;
}

QString RomMetaInformation::md5Hash() const
{
	return d->md5Hash;
}

void RomMetaInformation::setMd5Hash(const QString &md5Hash)
{
	d->md5Hash = md5Hash;
}

QString RomMetaInformation::year() const
{
	return d->year;
}

void RomMetaInformation::setYear(const QString &year)
{
	d->year = year;
}

QString RomMetaInformation::country() const
{
	return d->country;
}

void RomMetaInformation::setCountry(const QString &country)
{
	d->country = country;
}

QString RomMetaInformation::genre() const
{
	return d->genre;
}

void RomMetaInformation::setGenre(const QString &genre)
{
	d->genre = genre;
}

QString RomMetaInformation::titlescreenPath() const
{
	return d->titlescreenPath;
}

void RomMetaInformation::setTitlescreenPath(const QString &titlescreenPath)
{
	d->titlescreenPath = titlescreenPath;
}

QString RomMetaInformation::screenshotPath() const
{
	return d->screenshotPath;
}

void RomMetaInformation::setScreenshotPath(const QString &screenshotPath)
{
	d->screenshotPath = screenshotPath;
}

}
