/*
    emulatorconfigwidget.cpp - Emulator configuration widget

    Copyright (c) 2005      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "emulatorconfigwidget.h"

// Qt Includes
#include <qlayout.h>
#include <qlabel.h>
#include <qregexp.h>

// KDE includes
#include <kdebug.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>

class EmulatorConfigWidget::Private
{
public:
	Private()
	 : emulatorPath(0), emulatorArguments(0), buttonRequestUrl(0), config(0)
	{}
	KLineEdit *emulatorPath;
	KLineEdit *emulatorArguments;
	KPushButton *buttonRequestUrl;
	QString systemName;
	KConfig *config;
};

EmulatorConfigWidget::EmulatorConfigWidget(const QString &systemName, QWidget *parent, const char *name)
 : QGroupBox(parent, name), d(new Private())
{
	// Set systemname.
	d->systemName = systemName;
	setTitle(d->systemName);
	
	setColumnLayout(0, Qt::Vertical );	

	// Use GroupBox layout as the base.
	QGridLayout *mainLayout = new QGridLayout( layout() , 2, 2);
	
	// Path layout
	mainLayout->addWidget( new QLabel(i18n("Emulator path:"), this), 0, 0 );
	d->emulatorPath = new KLineEdit(this, "emulatorPath");
	// Dispatch changed signal
	connect(d->emulatorPath, SIGNAL(textChanged(const QString &)), this, SIGNAL(settingsChanged()));
	mainLayout->addWidget( d->emulatorPath, 0, 1 );

	// Arguments horizontal layout
	mainLayout->addWidget( new QLabel(i18n("Emulator arguments:"), this ), 1, 0);
	d->emulatorArguments = new KLineEdit(this, "emulatorArguments");
	// Dispatch changed signal
	connect(d->emulatorArguments, SIGNAL(textChanged(const QString &)), this, SIGNAL(settingsChanged()));
	mainLayout->addWidget( d->emulatorArguments, 1, 1 );
	
	// Set KConfig objet from KGlobal
	d->config = KGlobal::config();
}

EmulatorConfigWidget::~EmulatorConfigWidget()
{
	delete d;
}

void EmulatorConfigWidget::loadSettings()
{
	kdDebug() << "Loading emulator config for system " << d->systemName << endl;

	// Set the group, remove the spaces in the system name.
	d->config->setGroup( QString("Emulator_%1").arg( d->systemName ) );
	// Read the config and set the path.
	d->emulatorPath->setText( d->config->readEntry( QString::fromUtf8("EmulatorPath") ) );
	d->emulatorArguments->setText( d->config->readEntry( QString::fromUtf8("EmulatorArgs") ) );
}

void EmulatorConfigWidget::saveSettings()
{
	kdDebug() << "Saving emulator config for system " << d->systemName << endl;

	// Set the group, remove the spaces in the system name.
	d->config->setGroup( QString("Emulator_%1").arg( d->systemName ) );
	d->config->writeEntry( QString::fromUtf8("EmulatorPath"), d->emulatorPath->text() );
	d->config->writeEntry( QString::fromUtf8("EmulatorArgs"), d->emulatorArguments->text() );
}

#include "emulatorconfigwidget.moc"
