/*
    kamefudatabaseconfig.cpp - Database configuration

    Copyright (c) 2006      by Michaël Larouche       <michael.larouche@kdemail.net>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/
#include "kamefucollectionconfig.h"

// Qt includes
#include <qlayout.h>
#include <qcheckbox.h>
#include <qsqldatabase.h>
#include <qtabwidget.h>

// KDE includes
#include <kdebug.h>
#include <kgenericfactory.h>
#include <klocale.h>
#include <kcombobox.h>

// Kamefu includes
#include <kcheckdirectoryselector.h>
#include <kamefupreferences.h>
#include <databasepreferences.h>

#include "collectionconfig_collection.h"
#include "collectionconfig_database.h"

using namespace Kamefu::UI;

class KamefuCollectionConfig::Private
{
public:
	CollectionConfig_Collection *collectionConfigUi;
	CollectionConfig_Database *databaseConfigUi;
};

typedef KGenericFactory<KamefuCollectionConfig, QWidget> KamefuCollectionConfigFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kamefu_collectionconfig, KamefuCollectionConfigFactory( "kcm_kamefu_collectionconfig" ) )

KamefuCollectionConfig::KamefuCollectionConfig(QWidget* parent, const char* /*name*/, const QStringList& args)
	: KCModule( KamefuCollectionConfigFactory::instance(), parent, args ), d( new Private() )
{
	( new QVBoxLayout( this ) )->setAutoAdd( true );

	QTabWidget *tabWidget = new QTabWidget(this, "tabWidget");
	
	d->collectionConfigUi = new CollectionConfig_Collection(tabWidget);
	addConfig( KamefuPreferences::self(), d->collectionConfigUi );
	tabWidget->addTab( d->collectionConfigUi, i18n("General") );
	
	d->databaseConfigUi = new CollectionConfig_Database(tabWidget);
	addConfig( Kamefu::DatabasePreferences::self(), d->databaseConfigUi );
	tabWidget->addTab( d->databaseConfigUi, i18n("Database") );

	load();
}

KamefuCollectionConfig::~KamefuCollectionConfig()
{
	delete d;
}

void KamefuCollectionConfig::load()
{
	KCModule::load();
	
	d->collectionConfigUi->dirSelect->setDirs( KamefuPreferences::self()->collectionDirectories() );

	loadDatabaseDrivers();
}

void KamefuCollectionConfig::save()
{
	KCModule::save();

	KamefuPreferences::self()->setCollectionDirectories( d->collectionConfigUi->dirSelect->dirs() );
	KamefuPreferences::self()->writeConfig();

	Kamefu::DatabasePreferences::self()->setDriver( d->databaseConfigUi->databaseDriver->currentText() );
	Kamefu::DatabasePreferences::self()->writeConfig();
}

void KamefuCollectionConfig::loadDatabaseDrivers()
{
	d->databaseConfigUi->databaseDriver->clear();

	QStringList driverList = QSqlDatabase::drivers ();

	int currentIndex = 0;
	QStringList::ConstIterator it, itEnd = driverList.constEnd();
	for( it = driverList.constBegin(); it != itEnd; ++it )
	{
		d->databaseConfigUi->databaseDriver->insertItem( *it );
		if( *it == Kamefu::DatabasePreferences::self()->driver() )
		{
			d->databaseConfigUi->databaseDriver->setCurrentItem(currentIndex);
		}
		currentIndex++;
	}
}

#include "kamefucollectionconfig.moc"
